/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.common.search.Document;
import io.fluxcapacitor.common.search.Inverter;
import io.fluxcapacitor.common.search.JacksonInverter;
import io.fluxcapacitor.common.serialization.JsonUtils;
import io.fluxcapacitor.javaclient.common.serialization.AbstractSerializer;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingObject;
import io.fluxcapacitor.javaclient.common.serialization.SerializationException;
import io.fluxcapacitor.javaclient.common.serialization.casting.Caster;
import io.fluxcapacitor.javaclient.common.serialization.casting.CasterChain;
import io.fluxcapacitor.javaclient.common.serialization.casting.Converter;
import io.fluxcapacitor.javaclient.common.serialization.jackson.ObjectNodeConverter;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer
extends AbstractSerializer<JsonNode>
implements DocumentSerializer {
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    public static JsonMapper defaultObjectMapper = JsonUtils.writer;
    private final ObjectMapper objectMapper;
    private final Function<String, JavaType> typeCache = ObjectUtils.memoize(this::getJavaType);
    private final Function<Type, String> typeStringCache = ObjectUtils.memoize(this::getCanonicalType);
    private final Caster<Data<JsonNode>> jsonNodeUpcaster;
    private final Inverter<JsonNode> inverter;

    public JacksonSerializer() {
        this(Collections.emptyList());
    }

    public JacksonSerializer(Collection<?> upcasters) {
        this((ObjectMapper)defaultObjectMapper, upcasters);
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, Collections.emptyList());
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> casterCandidates) {
        this(objectMapper, casterCandidates, new ObjectNodeConverter(objectMapper));
    }

    public JacksonSerializer(ObjectMapper objectMapper, Collection<?> casterCandidates, Converter<JsonNode> converter) {
        super(casterCandidates, converter, "application/json");
        this.objectMapper = objectMapper;
        this.jsonNodeUpcaster = CasterChain.create(casterCandidates, JsonNode.class, false);
        this.inverter = new JacksonInverter(objectMapper);
    }

    @Override
    protected String asString(Type type) {
        return this.typeStringCache.apply(type);
    }

    @Override
    protected byte[] doSerialize(Object object) throws Exception {
        return this.objectMapper.writeValueAsBytes(object);
    }

    @Override
    protected Object doDeserialize(Data<byte[]> data, String type) throws Exception {
        return this.objectMapper.readValue((byte[])data.getValue(), this.typeCache.apply(type));
    }

    @Override
    protected JsonNode asIntermediateValue(Object input) {
        return input instanceof byte[] ? this.objectMapper.readTree((byte[])input) : (JsonNode)this.objectMapper.convertValue(input, JsonNode.class);
    }

    @Override
    protected boolean isKnownType(String type) {
        try {
            this.typeCache.apply(type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    protected Stream<DeserializingObject<byte[], ?>> deserializeUnknownType(SerializedObject<byte[], ?> s) {
        SerializedObject jsonNode = s.withData(new Data((Object)((byte[])s.data().getValue()), JsonNode.class.getName(), 0, this.getFormat()));
        return Stream.of(new DeserializingObject(jsonNode, type -> {
            try {
                return this.convert(this.objectMapper.readTree((byte[])jsonNode.data().getValue()), type);
            }
            catch (Exception e) {
                throw new SerializationException(String.format("Could not deserialize a %s to a %s. Invalid json?", type, s.data().getType()), e);
            }
        }));
    }

    protected JavaType getJavaType(String type) {
        return this.objectMapper.getTypeFactory().constructFromCanonical(type);
    }

    protected String getCanonicalType(Type type) {
        return this.objectMapper.constructType(type).toCanonical();
    }

    @Override
    public Document toDocument(Object value, String id, String collection, Instant timestamp, Instant end) {
        return this.inverter.toDocument(this.serialize(value), id, collection, timestamp, end);
    }

    @Override
    public <T> T fromDocument(Document document) {
        JsonNode jsonNode = (JsonNode)this.inverter.fromDocument(document);
        return this.jsonNodeUpcaster.cast(Stream.of(new Data((Object)jsonNode, document.getType(), document.getRevision(), this.getFormat()))).findFirst().map(d -> this.objectMapper.convertValue(d.getValue(), this.typeCache.apply(d.getType()))).orElse(null);
    }

    @Override
    public <T> T fromDocument(Document document, Class<T> type) {
        JsonNode jsonNode = (JsonNode)this.inverter.fromDocument(document);
        return this.jsonNodeUpcaster.cast(Stream.of(new Data((Object)jsonNode, document.getType(), document.getRevision(), this.getFormat()))).findFirst().map(d -> this.objectMapper.convertValue(d.getValue(), type)).orElse(null);
    }

    @Override
    public <V> V doConvert(Object value, Class<V> type) {
        return (V)this.objectMapper.convertValue(value, type);
    }

    @Override
    public Object doClone(Object value) {
        return ReflectionUtils.copyFields((Object)value, this.doConvert(this.objectMapper.createObjectNode(), value.getClass()));
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

