/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.IdentityProvider;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.search.DocumentSerializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import io.fluxcapacitor.javaclient.web.LocalServerConfig;
import io.fluxcapacitor.javaclient.web.WebResponseMapper;
import java.util.function.UnaryOperator;

public interface FluxCapacitorBuilder {
    public FluxCapacitorBuilder configureDefaultConsumer(MessageType var1, UnaryOperator<ConsumerConfiguration> var2);

    public FluxCapacitorBuilder addConsumerConfiguration(ConsumerConfiguration var1);

    public FluxCapacitorBuilder addBatchInterceptor(BatchInterceptor var1, MessageType ... var2);

    default public FluxCapacitorBuilder addDispatchInterceptor(DispatchInterceptor interceptor, MessageType ... forTypes) {
        return this.addDispatchInterceptor(interceptor, false, forTypes);
    }

    public FluxCapacitorBuilder addDispatchInterceptor(DispatchInterceptor var1, boolean var2, MessageType ... var3);

    default public FluxCapacitorBuilder addHandlerInterceptor(HandlerInterceptor interceptor, MessageType ... forTypes) {
        return this.addHandlerInterceptor(interceptor, false, forTypes);
    }

    public FluxCapacitorBuilder addHandlerInterceptor(HandlerInterceptor var1, boolean var2, MessageType ... var3);

    public FluxCapacitorBuilder replaceMessageRoutingInterceptor(DispatchInterceptor var1);

    public FluxCapacitorBuilder replaceCache(Cache var1);

    default public FluxCapacitorBuilder forwardWebRequestsToLocalServer(int port) {
        return this.forwardWebRequestsToLocalServer(LocalServerConfig.builder().port(port).build(), UnaryOperator.identity());
    }

    public FluxCapacitorBuilder forwardWebRequestsToLocalServer(LocalServerConfig var1, UnaryOperator<ConsumerConfiguration> var2);

    public FluxCapacitorBuilder replaceWebResponseMapper(WebResponseMapper var1);

    public FluxCapacitorBuilder withAggregateCache(Class<?> var1, Cache var2);

    public FluxCapacitorBuilder replaceRelationshipsCache(UnaryOperator<Cache> var1);

    public FluxCapacitorBuilder replaceIdentityProvider(UnaryOperator<IdentityProvider> var1);

    public FluxCapacitorBuilder addParameterResolver(ParameterResolver<DeserializingMessage> var1);

    public FluxCapacitorBuilder replaceSerializer(Serializer var1);

    public FluxCapacitorBuilder replaceCorrelationDataProvider(UnaryOperator<CorrelationDataProvider> var1);

    public FluxCapacitorBuilder replaceSnapshotSerializer(Serializer var1);

    public FluxCapacitorBuilder replaceDocumentSerializer(DocumentSerializer var1);

    public FluxCapacitorBuilder registerUserSupplier(UserProvider var1);

    public FluxCapacitorBuilder disableErrorReporting();

    public FluxCapacitorBuilder disableShutdownHook();

    public FluxCapacitorBuilder disableMessageCorrelation();

    public FluxCapacitorBuilder disablePayloadValidation();

    public FluxCapacitorBuilder disableDataProtection();

    public FluxCapacitorBuilder disableAutomaticAggregateCaching();

    public FluxCapacitorBuilder disableScheduledCommandHandler();

    public FluxCapacitorBuilder enableTrackingMetrics();

    public FluxCapacitorBuilder makeApplicationInstance(boolean var1);

    public FluxCapacitor build(Client var1);
}

