/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.ReadOnlyEntity;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Entity<T> {
    public static final ThreadLocal<Boolean> loading = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> applying = ThreadLocal.withInitial(() -> false);
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";

    public static boolean isLoading() {
        return loading.get();
    }

    public static boolean isApplying() {
        return applying.get();
    }

    public static String getAggregateId(HasMetadata message) {
        return message.getMetadata().get((Object)AGGREGATE_ID_METADATA_KEY);
    }

    public static Class<?> getAggregateType(HasMetadata message) {
        return Optional.ofNullable(message.getMetadata().get((Object)AGGREGATE_TYPE_METADATA_KEY)).map(c -> {
            try {
                return ReflectionUtils.classForName((String)c);
            }
            catch (Exception ignored) {
                return null;
            }
        }).orElse(null);
    }

    public Object id();

    public Class<T> type();

    public T get();

    public String idProperty();

    public Entity<?> parent();

    default public Entity<?> root() {
        return Optional.ofNullable(this.parent()).map(Entity::root).orElse(this);
    }

    default public String lastEventId() {
        return this.root().lastEventId();
    }

    default public Long lastEventIndex() {
        return this.root().lastEventIndex();
    }

    default public Instant timestamp() {
        return this.root().timestamp();
    }

    default public long sequenceNumber() {
        return this.root().sequenceNumber();
    }

    default public Entity<T> previous() {
        return this.root().previous().allEntities().filter(e -> Objects.equals(e.id(), this.id()) && Objects.equals(e.type(), this.type())).findFirst().orElse(null);
    }

    default public Entity<T> playBackToEvent(String eventId) {
        return this.playBackToCondition(aggregate -> Objects.equals(eventId, aggregate.lastEventId())).orElseThrow(() -> new IllegalStateException(String.format("Could not load aggregate %s of type %s for event %s. Aggregate (%s) started at event %s", this.id(), this.type().getSimpleName(), eventId, this, this.lastEventId())));
    }

    default public Optional<Entity<T>> playBackToCondition(Predicate<Entity<T>> condition) {
        Entity<T> result;
        for (result = this; result != null && !condition.test(result); result = result.previous()) {
        }
        return Optional.ofNullable(result);
    }

    public Collection<? extends Entity<?>> entities();

    default public Stream<Entity<?>> allEntities() {
        return Stream.concat(Stream.of(this), this.entities().stream().flatMap(Entity::allEntities));
    }

    default public Optional<Entity<?>> getEntity(Object entityId) {
        return this.allEntities().filter(e -> entityId != null && entityId.equals(e.id())).findFirst();
    }

    default public Entity<T> makeReadOnly() {
        if (this instanceof ReadOnlyEntity) {
            return this;
        }
        return new ReadOnlyEntity(this);
    }

    default public Set<Relationship> relationships() {
        String id = this.id().toString();
        String type = this.type().getName();
        return this.get() == null ? Collections.emptySet() : this.allEntities().map(Entity::id).filter(Objects::nonNull).map(entityId -> Relationship.builder().entityId(entityId.toString()).aggregateType(type).aggregateId(id).build()).collect(Collectors.toSet());
    }

    default public Set<Relationship> associations(Entity<?> previous) {
        HashSet<Relationship> result = new HashSet<Relationship>(this.relationships());
        result.removeAll(previous.relationships());
        return result;
    }

    default public Set<Relationship> dissociations(Entity<?> previous) {
        HashSet<Relationship> result = new HashSet<Relationship>(previous.relationships());
        result.removeAll(this.relationships());
        return result;
    }

    public Entity<T> update(UnaryOperator<T> var1);

    default public Entity<T> apply(Object ... events) {
        return this.apply(List.of(events));
    }

    default public Entity<T> apply(Collection<?> events) {
        Entity<T> result = this;
        for (Object event : events) {
            result = result.apply(event);
        }
        return result;
    }

    default public Entity<T> apply(Object event) {
        if (event instanceof DeserializingMessage) {
            return this.apply(((DeserializingMessage)event).toMessage());
        }
        return this.apply(Message.asMessage(event));
    }

    default public Entity<T> apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    public Entity<T> apply(Message var1);

    default public <E extends Exception> Entity<T> assertLegal(Object command) throws E {
        ValidationUtils.assertLegal(command, this.root());
        return this;
    }

    default public <E extends Exception> Entity<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> Entity<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    default public Entity<T> assertAndApply(Object payload) {
        return this.assertLegal(payload).apply(payload);
    }

    default public Entity<T> assertAndApply(Object payload, Metadata metadata) {
        return this.assertLegal(payload).apply(payload, metadata);
    }

    default public Iterable<Entity<?>> possibleTargets(Object payload) {
        for (Entity<?> e : this.entities()) {
            if (!e.isPossibleTarget(payload)) continue;
            return List.of(e);
        }
        return Collections.emptyList();
    }

    private boolean isPossibleTarget(Object message) {
        Object payload;
        if (message == null) {
            return false;
        }
        for (Entity<?> e : this.entities()) {
            if (!e.isPossibleTarget(message)) continue;
            return true;
        }
        String idProperty = this.idProperty();
        Object id = this.id();
        if (idProperty == null) {
            return true;
        }
        if (id == null && this.get() != null) {
            return false;
        }
        Object object = payload = message instanceof Message ? ((Message)message).getPayload() : message;
        if (id == null) {
            return ReflectionUtils.hasProperty((String)idProperty, (Object)payload);
        }
        return ReflectionUtils.readProperty((String)idProperty, (Object)payload).or(() -> ReflectionUtils.getAnnotatedPropertyValue((Object)payload, RoutingKey.class)).map(id::equals).orElse(false);
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

