/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandlerFactory;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;

@JsonDeserialize(builder=ImmutableAggregateRootBuilderImpl.class)
public final class ImmutableAggregateRoot<T>
extends ImmutableEntity<T> {
    @JsonProperty
    private final String lastEventId;
    @JsonProperty
    private final Long lastEventIndex;
    @JsonProperty
    private final Instant timestamp;
    @JsonProperty
    private final long sequenceNumber;
    private final transient ImmutableAggregateRoot<T> previous;
    private final AtomicReference<Object> relationships = new AtomicReference();

    public static <T> ImmutableAggregateRoot<T> from(Entity<T> a, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        if (a == null) {
            return null;
        }
        return ((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)ImmutableAggregateRoot.builder().handlerFactory(handlerFactory)).serializer(serializer)).id(a.id())).value(a.get())).type(a.type())).idProperty(a.idProperty())).lastEventId(a.lastEventId())).lastEventIndex(a.lastEventIndex())).timestamp(a.timestamp())).sequenceNumber(a.sequenceNumber())).previous(ImmutableAggregateRoot.from(a.previous(), handlerFactory, serializer))).build();
    }

    @Override
    public ImmutableAggregateRoot<T> apply(DeserializingMessage message) {
        return ((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRoot)super.apply(message)).toBuilder()).previous(this)).timestamp(message.getTimestamp())).lastEventId(message.getMessageId())).lastEventIndex(message.getIndex())).sequenceNumber(this.sequenceNumber() + 1L)).build();
    }

    @Override
    public ImmutableAggregateRoot<T> update(UnaryOperator<T> function) {
        return ((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)((ImmutableAggregateRoot)super.update(function)).toBuilder()).previous(this)).timestamp(FluxCapacitor.currentClock().instant())).build();
    }

    public ImmutableAggregateRoot<T> withEventIndex(Long index, String messageId) {
        if (Objects.equals(messageId, this.lastEventId)) {
            return this.lastEventIndex == null ? ((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)this.toBuilder()).lastEventIndex(index)).build() : this;
        }
        return ((ImmutableAggregateRootBuilder)((ImmutableAggregateRootBuilder)this.toBuilder()).previous(this.previous.withEventIndex(index, messageId))).build();
    }

    public Long highestEventIndex() {
        return Optional.ofNullable(this.lastEventIndex).or(() -> Optional.ofNullable(this.previous).map(ImmutableAggregateRoot::highestEventIndex)).orElse(null);
    }

    private static <T> Instant $default$timestamp() {
        return FluxCapacitor.currentClock().instant();
    }

    private static <T> long $default$sequenceNumber() {
        return -1L;
    }

    protected ImmutableAggregateRoot(ImmutableAggregateRootBuilder<T, ?, ?> b) {
        super(b);
        this.lastEventId = b.lastEventId;
        this.lastEventIndex = b.lastEventIndex;
        this.timestamp = b.timestamp$set ? b.timestamp$value : ImmutableAggregateRoot.$default$timestamp();
        this.sequenceNumber = b.sequenceNumber$set ? b.sequenceNumber$value : ImmutableAggregateRoot.$default$sequenceNumber();
        this.previous = b.previous;
    }

    public static <T> ImmutableAggregateRootBuilder<T, ?, ?> builder() {
        return new ImmutableAggregateRootBuilderImpl();
    }

    @Override
    public ImmutableAggregateRootBuilder<T, ?, ?> toBuilder() {
        return new ImmutableAggregateRootBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public String lastEventId() {
        return this.lastEventId;
    }

    @Override
    public Long lastEventIndex() {
        return this.lastEventIndex;
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public ImmutableAggregateRoot<T> previous() {
        return this.previous;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableAggregateRoot)) {
            return false;
        }
        ImmutableAggregateRoot other = (ImmutableAggregateRoot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.sequenceNumber() != other.sequenceNumber()) {
            return false;
        }
        Long this$lastEventIndex = this.lastEventIndex();
        Long other$lastEventIndex = other.lastEventIndex();
        if (this$lastEventIndex == null ? other$lastEventIndex != null : !((Object)this$lastEventIndex).equals(other$lastEventIndex)) {
            return false;
        }
        String this$lastEventId = this.lastEventId();
        String other$lastEventId = other.lastEventId();
        if (this$lastEventId == null ? other$lastEventId != null : !this$lastEventId.equals(other$lastEventId)) {
            return false;
        }
        Instant this$timestamp = this.timestamp();
        Instant other$timestamp = other.timestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImmutableAggregateRoot;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $sequenceNumber = this.sequenceNumber();
        result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
        Long $lastEventIndex = this.lastEventIndex();
        result = result * 59 + ($lastEventIndex == null ? 43 : ((Object)$lastEventIndex).hashCode());
        String $lastEventId = this.lastEventId();
        result = result * 59 + ($lastEventId == null ? 43 : $lastEventId.hashCode());
        Instant $timestamp = this.timestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ImmutableAggregateRoot(lastEventId=" + this.lastEventId() + ", lastEventIndex=" + this.lastEventIndex() + ", timestamp=" + this.timestamp() + ", sequenceNumber=" + this.sequenceNumber() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Relationship> relationships() {
        Object value = this.relationships.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.relationships;
            synchronized (atomicReference) {
                value = this.relationships.get();
                if (value == null) {
                    Set<Relationship> actualValue = super.relationships();
                    value = actualValue == null ? this.relationships : actualValue;
                    this.relationships.set(value);
                }
            }
        }
        return (Set)(value == this.relationships ? null : value);
    }

    public static abstract class ImmutableAggregateRootBuilder<T, C extends ImmutableAggregateRoot<T>, B extends ImmutableAggregateRootBuilder<T, C, B>>
    extends ImmutableEntity.ImmutableEntityBuilder<T, C, B> {
        private String lastEventId;
        private Long lastEventIndex;
        private boolean timestamp$set;
        private Instant timestamp$value;
        private boolean sequenceNumber$set;
        private long sequenceNumber$value;
        private ImmutableAggregateRoot<T> previous;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ImmutableAggregateRootBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(ImmutableAggregateRoot<T> instance, ImmutableAggregateRootBuilder<T, ?, ?> b) {
            b.lastEventId(instance.lastEventId);
            b.lastEventIndex(instance.lastEventIndex);
            b.timestamp(instance.timestamp);
            b.sequenceNumber(instance.sequenceNumber);
            b.previous(instance.previous);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty
        public B lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return (B)this.self();
        }

        @JsonProperty
        public B lastEventIndex(Long lastEventIndex) {
            this.lastEventIndex = lastEventIndex;
            return (B)this.self();
        }

        @JsonProperty
        public B timestamp(Instant timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return (B)this.self();
        }

        @JsonProperty
        public B sequenceNumber(long sequenceNumber) {
            this.sequenceNumber$value = sequenceNumber;
            this.sequenceNumber$set = true;
            return (B)this.self();
        }

        public B previous(ImmutableAggregateRoot<T> previous) {
            this.previous = previous;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ImmutableAggregateRoot.ImmutableAggregateRootBuilder(super=" + super.toString() + ", lastEventId=" + this.lastEventId + ", lastEventIndex=" + this.lastEventIndex + ", timestamp$value=" + this.timestamp$value + ", sequenceNumber$value=" + this.sequenceNumber$value + ", previous=" + this.previous + ")";
        }
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    static final class ImmutableAggregateRootBuilderImpl<T>
    extends ImmutableAggregateRootBuilder<T, ImmutableAggregateRoot<T>, ImmutableAggregateRootBuilderImpl<T>> {
        private ImmutableAggregateRootBuilderImpl() {
        }

        @Override
        protected ImmutableAggregateRootBuilderImpl<T> self() {
            return this;
        }

        @Override
        public ImmutableAggregateRoot<T> build() {
            return new ImmutableAggregateRoot(this);
        }
    }
}

