/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.AnnotatedEntityHolder;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.Member;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandler;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandlerFactory;
import java.beans.ConstructorProperties;
import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableEntity<T>
implements Entity<T> {
    private static final Logger log = LoggerFactory.getLogger(ImmutableEntity.class);
    @JsonProperty
    private final Object id;
    @JsonProperty
    private final Class<T> type;
    @JsonProperty
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
    private final T value;
    @JsonProperty
    private final String idProperty;
    private final transient Entity<?> parent;
    private final transient AnnotatedEntityHolder holder;
    private final transient EventSourcingHandlerFactory handlerFactory;
    private final transient Serializer serializer;
    private final AtomicReference<Object> entities = new AtomicReference();

    @Override
    public Class<T> type() {
        return this.value == null ? this.type : this.value.getClass();
    }

    @Override
    public T get() {
        return this.value;
    }

    private Collection<? extends ImmutableEntity<?>> computeEntities() {
        Class<Object> type = this.value == null ? this.type() : this.value.getClass();
        ArrayList result = new ArrayList();
        for (AccessibleObject location : ReflectionUtils.getAnnotatedProperties(type, Member.class)) {
            result.addAll(AnnotatedEntityHolder.getEntityHolder(type, location, this.handlerFactory, this.serializer).getEntities(this).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        Object after = ((ImmutableEntityBuilder)this.toBuilder().value(function.apply(this.get()))).build();
        if (this.parent == null) {
            return after;
        }
        return this.parent.update(p -> this.holder.updateOwner(p, this, (Entity<?>)after));
    }

    @Override
    public ImmutableEntity<T> apply(Message message) {
        return this.apply(new DeserializingMessage(message.serialize(this.serializer), type -> this.serializer.convert(message.getPayload(), type), MessageType.EVENT));
    }

    ImmutableEntity<T> apply(DeserializingMessage message) {
        EventSourcingHandler handler = this.handlerFactory.forType(this.type());
        Optional<HandlerInvoker> invoker = handler.findInvoker(this, message);
        if (invoker.isPresent()) {
            return ((ImmutableEntityBuilder)this.toBuilder().value(invoker.get().invoke())).build();
        }
        ImmutableEntity<Object> result = this;
        Object payload = message.getPayload();
        for (Entity<?> entity : result.possibleTargets(payload)) {
            ImmutableEntity immutableEntity = (ImmutableEntity)entity;
            ImmutableEntity<T> updated = immutableEntity.apply(message);
            if (immutableEntity.get() == updated.get()) continue;
            result = ((ImmutableEntityBuilder)result.toBuilder().value(immutableEntity.holder().updateOwner(result.get(), entity, updated))).build();
        }
        return result;
    }

    protected ImmutableEntity(ImmutableEntityBuilder<T, ?, ?> b) {
        this.id = b.id;
        this.type = b.type;
        this.value = b.value;
        this.idProperty = b.idProperty;
        this.parent = b.parent;
        this.holder = b.holder;
        this.handlerFactory = b.handlerFactory;
        this.serializer = b.serializer;
    }

    public static <T> ImmutableEntityBuilder<T, ?, ?> builder() {
        return new ImmutableEntityBuilderImpl();
    }

    public ImmutableEntityBuilder<T, ?, ?> toBuilder() {
        return new ImmutableEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public Object id() {
        return this.id;
    }

    public T value() {
        return this.value;
    }

    @Override
    public String idProperty() {
        return this.idProperty;
    }

    @Override
    public Entity<?> parent() {
        return this.parent;
    }

    public AnnotatedEntityHolder holder() {
        return this.holder;
    }

    public EventSourcingHandlerFactory handlerFactory() {
        return this.handlerFactory;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImmutableEntity)) {
            return false;
        }
        ImmutableEntity other = (ImmutableEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$id = this.id();
        Object other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<T> this$type = this.type();
        Class<T> other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        T this$value = this.value();
        T other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$idProperty = this.idProperty();
        String other$idProperty = other.idProperty();
        return !(this$idProperty == null ? other$idProperty != null : !this$idProperty.equals(other$idProperty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImmutableEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<T> $type = this.type();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        T $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $idProperty = this.idProperty();
        result = result * 59 + ($idProperty == null ? 43 : $idProperty.hashCode());
        return result;
    }

    public String toString() {
        return "ImmutableEntity(id=" + this.id() + ", type=" + this.type() + ", value=" + this.value() + ", idProperty=" + this.idProperty() + ")";
    }

    @ConstructorProperties(value={"id", "type", "value", "idProperty", "parent", "holder", "handlerFactory", "serializer"})
    public ImmutableEntity(Object id, Class<T> type, T value, String idProperty, Entity<?> parent, AnnotatedEntityHolder holder, EventSourcingHandlerFactory handlerFactory, Serializer serializer) {
        this.id = id;
        this.type = type;
        this.value = value;
        this.idProperty = idProperty;
        this.parent = parent;
        this.holder = holder;
        this.handlerFactory = handlerFactory;
        this.serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends Entity<?>> entities() {
        Object value = this.entities.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.entities;
            synchronized (atomicReference) {
                value = this.entities.get();
                if (value == null) {
                    Collection<ImmutableEntity<?>> actualValue = this.computeEntities();
                    value = actualValue == null ? this.entities : actualValue;
                    this.entities.set(value);
                }
            }
        }
        return (Collection)(value == this.entities ? null : value);
    }

    public static abstract class ImmutableEntityBuilder<T, C extends ImmutableEntity<T>, B extends ImmutableEntityBuilder<T, C, B>> {
        private Object id;
        private Class<T> type;
        private T value;
        private String idProperty;
        private Entity<?> parent;
        private AnnotatedEntityHolder holder;
        private EventSourcingHandlerFactory handlerFactory;
        private Serializer serializer;

        protected B $fillValuesFrom(C instance) {
            ImmutableEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(ImmutableEntity<T> instance, ImmutableEntityBuilder<T, ?, ?> b) {
            b.id(instance.id);
            b.type(instance.type);
            b.value(instance.value);
            b.idProperty(instance.idProperty);
            b.parent(instance.parent);
            b.holder(instance.holder);
            b.handlerFactory(instance.handlerFactory);
            b.serializer(instance.serializer);
        }

        protected abstract B self();

        public abstract C build();

        @JsonProperty
        public B id(Object id) {
            this.id = id;
            return this.self();
        }

        @JsonProperty
        public B type(Class<T> type) {
            this.type = type;
            return this.self();
        }

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="type")
        public B value(T value) {
            this.value = value;
            return this.self();
        }

        @JsonProperty
        public B idProperty(String idProperty) {
            this.idProperty = idProperty;
            return this.self();
        }

        public B parent(Entity<?> parent) {
            this.parent = parent;
            return this.self();
        }

        public B holder(AnnotatedEntityHolder holder) {
            this.holder = holder;
            return this.self();
        }

        public B handlerFactory(EventSourcingHandlerFactory handlerFactory) {
            this.handlerFactory = handlerFactory;
            return this.self();
        }

        public B serializer(Serializer serializer) {
            this.serializer = serializer;
            return this.self();
        }

        public String toString() {
            return "ImmutableEntity.ImmutableEntityBuilder(id=" + this.id + ", type=" + this.type + ", value=" + this.value + ", idProperty=" + this.idProperty + ", parent=" + this.parent + ", holder=" + this.holder + ", handlerFactory=" + this.handlerFactory + ", serializer=" + this.serializer + ")";
        }
    }

    private static final class ImmutableEntityBuilderImpl<T>
    extends ImmutableEntityBuilder<T, ImmutableEntity<T>, ImmutableEntityBuilderImpl<T>> {
        private ImmutableEntityBuilderImpl() {
        }

        @Override
        protected ImmutableEntityBuilderImpl<T> self() {
            return this;
        }

        @Override
        public ImmutableEntity<T> build() {
            return new ImmutableEntity(this);
        }
    }
}

