/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.modeling.DelegatingEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.ImmutableEntity;
import io.fluxcapacitor.javaclient.modeling.ModifiableEntity;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ModifiableAggregateRoot<T>
extends DelegatingEntity<T> {
    private static final ThreadLocal<Map<Object, ModifiableAggregateRoot<?>>> activeAggregates = ThreadLocal.withInitial(HashMap::new);
    private Entity<T> lastCommitted;
    private Entity<T> lastStable;
    private final boolean commitInBatch;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;
    private final CommitHandler commitHandler;
    private final AtomicBoolean waitingForHandlerEnd = new AtomicBoolean();
    private final AtomicBoolean waitingForBatchEnd = new AtomicBoolean();
    private final List<DeserializingMessage> applied = new ArrayList<DeserializingMessage>();
    private final List<DeserializingMessage> uncommitted = new ArrayList<DeserializingMessage>();
    private final List<Message> queued = new ArrayList<Message>();
    private volatile boolean applying;

    public static <T> Optional<ModifiableAggregateRoot<T>> getIfActive(String aggregateId) {
        return Optional.ofNullable(activeAggregates.get().get(aggregateId));
    }

    public static <T> ModifiableAggregateRoot<T> load(String aggregateId, Supplier<ImmutableEntity<T>> loader, boolean commitInBatch, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        return ModifiableAggregateRoot.getIfActive(aggregateId).orElseGet(() -> new ModifiableAggregateRoot((ImmutableEntity)loader.get(), commitInBatch, serializer, dispatchInterceptor, commitHandler));
    }

    protected ModifiableAggregateRoot(ImmutableEntity<T> delegate, boolean commitInBatch, Serializer serializer, DispatchInterceptor dispatchInterceptor, CommitHandler commitHandler) {
        super(delegate);
        this.lastCommitted = delegate;
        this.lastStable = delegate;
        this.commitInBatch = commitInBatch;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
        this.commitHandler = commitHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifiableAggregateRoot<T> apply(Message message) {
        if (this.applying) {
            this.queued.add(message);
            return this;
        }
        Message m = this.dispatchInterceptor.interceptDispatch(message, MessageType.EVENT).addMetadata("$aggregateId", this.id(), "$aggregateType", this.type().getName());
        DeserializingMessage eventMessage = new DeserializingMessage(this.dispatchInterceptor.modifySerializedMessage(m.serialize(this.serializer), m, MessageType.EVENT), type -> this.serializer.convert(m.getPayload(), type), MessageType.EVENT);
        try {
            this.applying = true;
            this.handleUpdate(a -> {
                Entity result = a.apply((Object)eventMessage);
                this.applied.add(eventMessage);
                return result;
            });
        }
        finally {
            this.applying = false;
        }
        while (!this.queued.isEmpty()) {
            this.apply(this.queued.remove(0));
        }
        return this;
    }

    @Override
    public ModifiableAggregateRoot<T> update(UnaryOperator<T> function) {
        this.handleUpdate(a -> a.update(function));
        return this;
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return super.entities().stream().map(e -> new ModifiableEntity(e, this)).collect(Collectors.toList());
    }

    @Override
    public Entity<T> previous() {
        return new ModifiableEntity(this.delegate.previous(), this);
    }

    protected void handleUpdate(UnaryOperator<Entity<T>> update) {
        boolean firstUpdate = this.waitingForHandlerEnd.compareAndSet(false, true);
        if (firstUpdate) {
            activeAggregates.get().putIfAbsent(this.id(), this);
        }
        try {
            this.delegate = (Entity)update.apply(this.getDelegate());
        }
        finally {
            if (firstUpdate) {
                Invocation.whenHandlerCompletes((r, e) -> this.whenHandlerCompletes((Throwable)e));
            }
        }
    }

    protected void whenHandlerCompletes(Throwable error) {
        this.waitingForHandlerEnd.set(false);
        if (error == null) {
            this.uncommitted.addAll(this.applied);
            this.applied.clear();
            this.lastStable = this.getDelegate();
            if (!this.commitInBatch) {
                this.commit();
            } else if (this.waitingForBatchEnd.compareAndSet(false, true)) {
                DeserializingMessage.whenBatchCompletes(e -> this.commit());
            }
        } else {
            this.applied.clear();
            this.delegate = this.lastStable;
            if (!this.commitInBatch) {
                activeAggregates.get().remove(this.id(), this);
            } else if (this.waitingForBatchEnd.compareAndSet(false, true)) {
                DeserializingMessage.whenBatchCompletes(e -> this.commit());
            }
        }
    }

    protected void commit() {
        activeAggregates.get().remove(this.id(), this);
        ArrayList<DeserializingMessage> events = new ArrayList<DeserializingMessage>(this.uncommitted);
        this.uncommitted.clear();
        this.waitingForBatchEnd.set(false);
        this.commitHandler.handle(this.lastStable, events, this.lastCommitted);
        this.lastCommitted = this.lastStable;
    }

    public String toString() {
        return "ModifiableAggregateRoot()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifiableAggregateRoot)) {
            return false;
        }
        ModifiableAggregateRoot other = (ModifiableAggregateRoot)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifiableAggregateRoot;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @FunctionalInterface
    public static interface CommitHandler {
        public void handle(Entity<?> var1, List<DeserializingMessage> var2, Entity<?> var3);
    }
}

