/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import java.beans.ConstructorProperties;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DefaultCache
implements Cache {
    private final Map<Object, SoftReference<Object>> delegate;

    public DefaultCache() {
        this(1000);
    }

    public DefaultCache(final int maxSize) {
        this.delegate = Collections.synchronizedMap(new LinkedHashMap<Object, SoftReference<Object>>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, SoftReference<Object>> eldest) {
                return this.size() > maxSize;
            }
        });
    }

    @Override
    public Object put(Object id, Object value) {
        return this.unwrap(this.delegate.put(id, new SoftReference<Object>(value)));
    }

    @Override
    public Object putIfAbsent(Object id, Object value) {
        return this.computeIfAbsent(id, k -> value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        return this.unwrap(this.delegate.compute(id, (? super K k, ? super V v) -> this.unwrap((SoftReference<Object>)v) == null ? new SoftReference(mappingFunction.apply(k)) : v));
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.unwrap(this.delegate.compute(id, (? super K k, ? super V v) -> {
            Object current = this.unwrap((SoftReference<Object>)v);
            return current == null ? null : new SoftReference(mappingFunction.apply(k, current));
        }));
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        return this.unwrap(this.delegate.compute(id, (? super K k, ? super V v) -> new SoftReference(mappingFunction.apply(k, this.unwrap((SoftReference<Object>)v)))));
    }

    @Override
    public <T> T getIfPresent(Object id) {
        return this.unwrap(this.delegate.get(id));
    }

    @Override
    public void invalidate(Object id) {
        this.delegate.remove(id);
    }

    @Override
    public void invalidateAll() {
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    protected <T> T unwrap(SoftReference<Object> ref) {
        return (T)(ref == null ? null : ref.get());
    }

    @ConstructorProperties(value={"delegate"})
    public DefaultCache(Map<Object, SoftReference<Object>> delegate) {
        this.delegate = delegate;
    }
}

