/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.caching;

import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.persisting.caching.Cache;
import io.fluxcapacitor.javaclient.persisting.caching.DefaultCache;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public class SelectiveCache
implements Cache {
    private final Cache delegate;
    private final Predicate<Object> selector;
    private final Cache nextCache;

    public static Predicate<Object> aggregateSelector(Class<?> type) {
        return v -> {
            if (v instanceof Entity) {
                Entity aggregateRoot = (Entity)v;
                return Optional.ofNullable(aggregateRoot.get()).map(r -> type.isAssignableFrom(r.getClass())).orElseGet(() -> type.isAssignableFrom(aggregateRoot.type()));
            }
            return false;
        };
    }

    public SelectiveCache(Cache nextCache, Predicate<Object> selector) {
        this(new DefaultCache(), selector, nextCache);
    }

    @Override
    public Object put(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.selector.test(value) ? this.delegate.put(id, value) : this.nextCache.put(id, value);
    }

    @Override
    public Object putIfAbsent(Object id, @NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.selector.test(value) ? this.delegate.putIfAbsent(id, value) : this.nextCache.putIfAbsent(id, value);
    }

    @Override
    public <T> T computeIfAbsent(Object id, Function<? super Object, T> mappingFunction) {
        T result = this.getIfPresent(id);
        return result == null ? (this.selector.test(mappingFunction.apply(id)) ? this.delegate.computeIfAbsent(id, mappingFunction) : this.nextCache.computeIfAbsent(id, mappingFunction)) : result;
    }

    @Override
    public <T> T computeIfPresent(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        T result = this.getIfPresent(id);
        return result == null ? null : (this.selector.test(result) ? (T)this.delegate.computeIfPresent(id, mappingFunction) : (T)this.nextCache.computeIfPresent(id, mappingFunction));
    }

    @Override
    public <T> T compute(Object id, BiFunction<? super Object, ? super T, ? extends T> mappingFunction) {
        Object result = Optional.ofNullable(this.getIfPresent(id)).orElseGet(() -> mappingFunction.apply(id, null));
        return this.selector.test(result) ? this.delegate.compute(id, mappingFunction) : this.nextCache.compute(id, mappingFunction);
    }

    @Override
    public <T> T getIfPresent(Object id) {
        return (T)Optional.ofNullable(this.delegate.getIfPresent(id)).orElseGet(() -> this.nextCache.getIfPresent(id));
    }

    @Override
    public void invalidate(Object id) {
        this.delegate.invalidate(id);
        this.nextCache.invalidate(id);
    }

    @Override
    public void invalidateAll() {
        this.delegate.invalidateAll();
        this.nextCache.invalidateAll();
    }

    @Override
    public int size() {
        return this.delegate.size() + this.nextCache.size();
    }

    @ConstructorProperties(value={"delegate", "selector", "nextCache"})
    public SelectiveCache(Cache delegate, Predicate<Object> selector, Cache nextCache) {
        this.delegate = delegate;
        this.selector = selector;
        this.nextCache = nextCache;
    }
}

