/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.DeserializingMessageWithEntity;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityParameterResolver;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.Apply;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.ApplyEvent;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.EventSourcingHandler;
import io.fluxcapacitor.javaclient.tracking.handling.PayloadParameterResolver;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class AnnotatedEventSourcingHandler<T>
implements EventSourcingHandler<T> {
    private final Class<? extends T> handlerType;
    private final HandlerMatcher<DeserializingMessage> entityInvoker;
    private final EntityParameterResolver entityResolver = new EntityParameterResolver();
    private final Function<Class<?>, HandlerMatcher<DeserializingMessage>> eventInvokers;

    public AnnotatedEventSourcingHandler(Class<? extends T> handlerType, List<ParameterResolver<? super DeserializingMessage>> parameterResolvers) {
        this.handlerType = handlerType;
        this.entityInvoker = HandlerInspector.inspect(handlerType, parameterResolvers, (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(ApplyEvent.class).build());
        this.eventInvokers = ObjectUtils.memoize(eventType -> {
            ArrayList paramResolvers = new ArrayList(parameterResolvers);
            paramResolvers.stream().filter(p -> p instanceof PayloadParameterResolver).findFirst().ifPresentOrElse(payloadResolver -> paramResolvers.add(paramResolvers.indexOf(payloadResolver), this.entityResolver), () -> paramResolvers.add(this.entityResolver));
            return HandlerInspector.inspect((Class)eventType, paramResolvers, (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(Apply.class).handlerFilter((type, executable) -> {
                if (executable instanceof Method) {
                    Class<?> returnType = ((Method)executable).getReturnType();
                    return handlerType.isAssignableFrom(returnType) || returnType.isAssignableFrom(handlerType) || returnType.equals(Void.TYPE);
                }
                return false;
            }).build());
        });
    }

    @Override
    public Optional<HandlerInvoker> findInvoker(final Entity<T> entity, DeserializingMessage event) {
        final DeserializingMessageWithEntity message = new DeserializingMessageWithEntity(event, entity);
        return this.entityInvoker.findInvoker(entity.get(), (Object)message).or(() -> this.eventInvokers.apply(message.getPayloadClass()).findInvoker(message.getPayload(), (Object)message)).map(i -> new HandlerInvoker.DelegatingHandlerInvoker((HandlerInvoker)i){

            public Object invoke(BiFunction<Object, Object, Object> combiner) {
                return message.apply(m -> {
                    boolean wasApplying = Entity.isApplying();
                    try {
                        Entity.applying.set(true);
                        Object entityValue = entity.get();
                        Object result = this.delegate.invoke();
                        if (entityValue == null) {
                            Object t = AnnotatedEventSourcingHandler.this.handlerType.cast(result);
                            return t;
                        }
                        if (AnnotatedEventSourcingHandler.this.handlerType.isInstance(result)) {
                            Object t = AnnotatedEventSourcingHandler.this.handlerType.cast(result);
                            return t;
                        }
                        if (result == null && this.delegate.expectResult()) {
                            Object var6_8 = null;
                            return var6_8;
                        }
                        Object t = entityValue;
                        return t;
                    }
                    finally {
                        Entity.applying.set(wasApplying);
                    }
                });
            }
        });
    }
}

