/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.BooleanResult;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.DeleteEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetAggregateIdsResult;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebSocketEventStoreClient
extends AbstractWebsocketClient
implements EventStoreClient {
    private final Backlog<EventBatch> backlog;
    private final int fetchBatchSize;

    public WebSocketEventStoreClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), 1024, 8192, clientConfig);
    }

    public WebSocketEventStoreClient(String endPointUrl, int backlogSize, WebSocketClient.ClientConfig clientConfig) {
        this(URI.create(endPointUrl), backlogSize, 1024, clientConfig);
    }

    public WebSocketEventStoreClient(URI endPointUri, int backlogSize, int fetchBatchSize, WebSocketClient.ClientConfig clientConfig) {
        this(endPointUri, backlogSize, fetchBatchSize, clientConfig, true);
    }

    public WebSocketEventStoreClient(URI endPointUri, int backlogSize, int fetchBatchSize, WebSocketClient.ClientConfig clientConfig, boolean sendMetrics) {
        super(endPointUri, clientConfig, sendMetrics, clientConfig.getEventSourcingSessions());
        this.backlog = new Backlog(this::doSend, backlogSize);
        this.fetchBatchSize = fetchBatchSize;
    }

    @Override
    public Awaitable storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        return this.backlog.add((Object[])new EventBatch[]{new EventBatch(aggregateId, events, storeOnly)});
    }

    private Awaitable doSend(List<EventBatch> batches) {
        this.sendAndWait((Request)new AppendEvents(batches));
        return Awaitable.ready();
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        AtomicReference highestSequenceNumber = new AtomicReference();
        GetEventsResult firstBatch = (GetEventsResult)this.sendAndWait((Request)new GetEvents(aggregateId, Long.valueOf(lastSequenceNumber), this.fetchBatchSize));
        Stream eventStream = ObjectUtils.iterate((Object)firstBatch, r -> (GetEventsResult)this.sendAndWait((Request)new GetEvents(aggregateId, Long.valueOf(r.getLastSequenceNumber()), this.fetchBatchSize)), r -> r.getEventBatch().getEvents().size() < this.fetchBatchSize).flatMap(r -> {
            if (!r.getEventBatch().isEmpty()) {
                highestSequenceNumber.set(r.getLastSequenceNumber());
            }
            return r.getEventBatch().getEvents().stream();
        });
        return new AggregateEventStream<SerializedMessage>(eventStream, aggregateId, highestSequenceNumber::get);
    }

    @Override
    public Awaitable updateRelationships(UpdateRelationships request) {
        switch (request.getGuarantee()) {
            case NONE: {
                this.sendAndForget((JsonType)request);
                return Awaitable.ready();
            }
            case SENT: {
                return this.sendAndForget((JsonType)request);
            }
        }
        return Awaitable.fromFuture(this.send((Request)request));
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return ((GetAggregateIdsResult)this.sendAndWait((Request)request)).getAggregateIds();
    }

    @Override
    public CompletableFuture<Boolean> deleteEvents(String aggregateId) {
        return this.send((Request)new DeleteEvents(aggregateId)).thenApply(r -> ((BooleanResult)r).isSuccess());
    }
}

