/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.Timeout;
import io.fluxcapacitor.javaclient.publishing.TimeoutException;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public interface GenericGateway
extends HasLocalHandlers {
    default public void sendAndForget(Object message) {
        this.sendAndForget(Message.asMessage(message), Guarantee.NONE).get();
    }

    default public void sendAndForget(Object payload, Metadata metadata) {
        this.sendAndForget(new Message(payload, metadata), Guarantee.NONE).get();
    }

    default public void sendAndForget(Object payload, Metadata metadata, Guarantee guarantee) {
        this.sendAndForget(new Message(payload, metadata), guarantee).get();
    }

    default public CompletableFuture<Void> sendAndForget(Message message, Guarantee guarantee) {
        return this.sendAndForget(guarantee, message);
    }

    default public void sendAndForget(Object ... messages) {
        this.sendAndForget(Guarantee.NONE, messages);
    }

    default public CompletableFuture<Void> sendAndForget(Guarantee guarantee, Object ... messages) {
        return this.sendAndForget(guarantee, (Message[])Arrays.stream(messages).map(Message::asMessage).toArray(Message[]::new));
    }

    public CompletableFuture<Void> sendAndForget(Guarantee var1, Message ... var2);

    default public <R> CompletableFuture<R> send(Message message) {
        return this.sendForMessage(message).thenApply(Message::getPayload);
    }

    default public <R> CompletableFuture<R> send(Object message) {
        return this.send(Message.asMessage(message));
    }

    default public <R> CompletableFuture<R> send(Object payload, Metadata metadata) {
        return this.send(new Message(payload, metadata));
    }

    default public CompletableFuture<Message> sendForMessage(Message message) {
        return this.sendForMessages(message).get(0);
    }

    default public <R> List<CompletableFuture<R>> send(Object ... messages) {
        return this.sendForMessages((Message[])Arrays.stream(messages).map(Message::asMessage).toArray(Message[]::new)).stream().map(f -> f.thenApply(Message::getPayload)).collect(Collectors.toList());
    }

    public List<CompletableFuture<Message>> sendForMessages(Message ... var1);

    default public <R> R sendAndWait(Object message) {
        return this.sendAndWait(Message.asMessage(message));
    }

    default public <R> R sendAndWait(Object payload, Metadata metadata) {
        return this.sendAndWait(new Message(payload, metadata));
    }

    default public <R> R sendAndWait(Message message) {
        CompletableFuture<R> future = this.send(message);
        try {
            Timeout timeout = message.getPayload().getClass().getAnnotation(Timeout.class);
            if (timeout != null) {
                return future.get(timeout.millis(), TimeUnit.MILLISECONDS);
            }
            return future.get(1L, TimeUnit.MINUTES);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException(String.format("Request %s (type %s) has timed out", message.getMessageId(), message.getPayloadClass()));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GatewayException(String.format("Thread interrupted while waiting for result of %s (type %s)", message.getMessageId(), message.getPayloadClass()), e);
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void close();
}

