/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.client;

import io.fluxcapacitor.common.Awaitable;
import io.fluxcapacitor.common.Backlog;
import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.JsonType;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.publishing.Append;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import javax.websocket.ClientEndpoint;

@ClientEndpoint
public class WebsocketGatewayClient
extends AbstractWebsocketClient
implements GatewayClient {
    private final Backlog<SerializedMessage> sendBacklog;
    private final Backlog<SerializedMessage> storeBacklog;

    public WebsocketGatewayClient(String endPointUrl, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(URI.create(endPointUrl), 1024, clientConfig, type);
    }

    public WebsocketGatewayClient(String endPointUrl, int backlogSize, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(URI.create(endPointUrl), backlogSize, clientConfig, type);
    }

    public WebsocketGatewayClient(URI endPointUri, int backlogSize, WebSocketClient.ClientConfig clientConfig, MessageType type) {
        this(endPointUri, backlogSize, clientConfig, type, type != MessageType.METRICS);
    }

    public WebsocketGatewayClient(URI endPointUri, int backlogSize, WebSocketClient.ClientConfig clientConfig, MessageType type, boolean sendMetrics) {
        super(endPointUri, clientConfig, sendMetrics, clientConfig.getGatewaySessions().get(type));
        this.sendBacklog = new Backlog(this::doSend, backlogSize);
        this.storeBacklog = new Backlog(this::doStore, backlogSize);
    }

    @Override
    public Awaitable send(Guarantee guarantee, SerializedMessage ... messages) {
        switch (guarantee) {
            case NONE: {
                Awaitable ignored = this.sendBacklog.add((Object[])messages);
                return Awaitable.ready();
            }
            case SENT: {
                return this.sendBacklog.add((Object[])messages);
            }
            case STORED: {
                return this.storeBacklog.add((Object[])messages);
            }
        }
        throw new UnsupportedOperationException("Unrecognized guarantee: " + guarantee);
    }

    public Registration registerMonitor(Consumer<SerializedMessage> monitor) {
        return this.sendBacklog.registerMonitor(messages -> messages.forEach(monitor));
    }

    private Awaitable doSend(List<SerializedMessage> messages) {
        return this.sendAndForget((JsonType)new Append(messages, Guarantee.SENT));
    }

    protected Awaitable doStore(List<SerializedMessage> messages) {
        this.sendAndWait((Request)new Append(messages, Guarantee.STORED));
        return Awaitable.ready();
    }
}

