/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing.correlation;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.correlation.CorrelationDataProvider;
import io.fluxcapacitor.javaclient.tracking.Tracker;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public enum DefaultCorrelationDataProvider implements CorrelationDataProvider
{
    INSTANCE;

    private final String clientIdKey = "$clientId";
    private final String clientNameKey = "$clientName";
    private final String consumerKey = "$consumer";
    private final String correlationIdKey = "$correlationId";
    private final String traceIdKey = "$traceId";
    private final String triggerKey = "$trigger";

    @Override
    public Map<String, String> getCorrelationData(DeserializingMessage currentMessage) {
        HashMap<String, String> result = new HashMap<String, String>();
        FluxCapacitor.getOptionally().ifPresent(f -> {
            result.put("$clientId", f.client().id());
            result.put("$clientName", f.client().name());
        });
        Tracker.current().ifPresent(t -> result.put("$consumer", t.getName()));
        Optional.ofNullable(currentMessage).ifPresent(m -> {
            String correlationId = Optional.ofNullable(m.getIndex()).map(Object::toString).orElse(m.getMessageId());
            result.put(this.correlationIdKey, correlationId);
            result.put("$traceId", currentMessage.getMetadata().getOrDefault((Object)"$traceId", correlationId));
            result.put("$trigger", m.getType());
            result.putAll(currentMessage.getMetadata().getTraceEntries());
        });
        return result;
    }

    public String getClientIdKey() {
        return this.clientIdKey;
    }

    public String getClientNameKey() {
        return this.clientNameKey;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getCorrelationIdKey() {
        return this.correlationIdKey;
    }

    public String getTraceIdKey() {
        return this.traceIdKey;
    }

    public String getTriggerKey() {
        return this.triggerKey;
    }
}

