/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.tracking.BatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.ErrorHandler;
import io.fluxcapacitor.javaclient.tracking.LoggingErrorHandler;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.NonNull;

public final class ConsumerConfiguration {
    public static Function<MessageType, String> DEFAULT_CONSUMER_NAME = Enum::name;
    @NonNull
    private final MessageType messageType;
    @NonNull
    private final String name;
    private final boolean prependApplicationName;
    @NonNull
    private final Predicate<Object> handlerFilter;
    @NonNull
    private final ErrorHandler errorHandler;
    private final int threads;
    private final String typeFilter;
    private final int maxFetchBatchSize;
    @NonNull
    private final Duration maxWaitDuration;
    private final List<BatchInterceptor> batchInterceptors;
    private final boolean ignoreMessageTarget;
    private final boolean ignoreSegment;
    private final Long minIndex;
    private final Long maxIndexExclusive;
    private final boolean exclusive;
    private final boolean passive;
    private final Function<Client, String> trackerIdFactory;
    private final Duration purgeDelay;

    public static ConsumerConfiguration getDefault(MessageType messageType) {
        return ConsumerConfiguration.builder().messageType(messageType).name(DEFAULT_CONSUMER_NAME.apply(messageType)).ignoreSegment(EnumSet.of(MessageType.NOTIFICATION, MessageType.RESULT).contains(messageType)).build();
    }

    private static boolean $default$prependApplicationName() {
        return true;
    }

    private static Predicate<Object> $default$handlerFilter() {
        return o -> true;
    }

    private static ErrorHandler $default$errorHandler() {
        return new LoggingErrorHandler();
    }

    private static int $default$threads() {
        return 1;
    }

    private static String $default$typeFilter() {
        return null;
    }

    private static int $default$maxFetchBatchSize() {
        return 1024;
    }

    private static Duration $default$maxWaitDuration() {
        return Duration.ofSeconds(60L);
    }

    private static boolean $default$ignoreMessageTarget() {
        return false;
    }

    private static boolean $default$ignoreSegment() {
        return false;
    }

    private static Long $default$minIndex() {
        return null;
    }

    private static Long $default$maxIndexExclusive() {
        return null;
    }

    private static boolean $default$exclusive() {
        return true;
    }

    private static boolean $default$passive() {
        return false;
    }

    private static Function<Client, String> $default$trackerIdFactory() {
        return client -> String.format("%s_%s", client.id(), UUID.randomUUID());
    }

    private static Duration $default$purgeDelay() {
        return null;
    }

    @ConstructorProperties(value={"messageType", "name", "prependApplicationName", "handlerFilter", "errorHandler", "threads", "typeFilter", "maxFetchBatchSize", "maxWaitDuration", "batchInterceptors", "ignoreMessageTarget", "ignoreSegment", "minIndex", "maxIndexExclusive", "exclusive", "passive", "trackerIdFactory", "purgeDelay"})
    ConsumerConfiguration(@NonNull MessageType messageType, @NonNull String name, boolean prependApplicationName, @NonNull Predicate<Object> handlerFilter, @NonNull ErrorHandler errorHandler, int threads, String typeFilter, int maxFetchBatchSize, @NonNull Duration maxWaitDuration, List<BatchInterceptor> batchInterceptors, boolean ignoreMessageTarget, boolean ignoreSegment, Long minIndex, Long maxIndexExclusive, boolean exclusive, boolean passive, Function<Client, String> trackerIdFactory, Duration purgeDelay) {
        if (messageType == null) {
            throw new NullPointerException("messageType is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (handlerFilter == null) {
            throw new NullPointerException("handlerFilter is marked non-null but is null");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        if (maxWaitDuration == null) {
            throw new NullPointerException("maxWaitDuration is marked non-null but is null");
        }
        this.messageType = messageType;
        this.name = name;
        this.prependApplicationName = prependApplicationName;
        this.handlerFilter = handlerFilter;
        this.errorHandler = errorHandler;
        this.threads = threads;
        this.typeFilter = typeFilter;
        this.maxFetchBatchSize = maxFetchBatchSize;
        this.maxWaitDuration = maxWaitDuration;
        this.batchInterceptors = batchInterceptors;
        this.ignoreMessageTarget = ignoreMessageTarget;
        this.ignoreSegment = ignoreSegment;
        this.minIndex = minIndex;
        this.maxIndexExclusive = maxIndexExclusive;
        this.exclusive = exclusive;
        this.passive = passive;
        this.trackerIdFactory = trackerIdFactory;
        this.purgeDelay = purgeDelay;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().messageType(this.messageType).name(this.name).prependApplicationName(this.prependApplicationName).handlerFilter(this.handlerFilter).errorHandler(this.errorHandler).threads(this.threads).typeFilter(this.typeFilter).maxFetchBatchSize(this.maxFetchBatchSize).maxWaitDuration(this.maxWaitDuration).ignoreMessageTarget(this.ignoreMessageTarget).ignoreSegment(this.ignoreSegment).minIndex(this.minIndex).maxIndexExclusive(this.maxIndexExclusive).exclusive(this.exclusive).passive(this.passive).trackerIdFactory(this.trackerIdFactory).purgeDelay(this.purgeDelay);
        if (this.batchInterceptors != null) {
            builder.batchInterceptors(this.batchInterceptors);
        }
        return builder;
    }

    @NonNull
    public MessageType getMessageType() {
        return this.messageType;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public boolean prependApplicationName() {
        return this.prependApplicationName;
    }

    @NonNull
    public Predicate<Object> getHandlerFilter() {
        return this.handlerFilter;
    }

    @NonNull
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public int getThreads() {
        return this.threads;
    }

    public String getTypeFilter() {
        return this.typeFilter;
    }

    public int getMaxFetchBatchSize() {
        return this.maxFetchBatchSize;
    }

    @NonNull
    public Duration getMaxWaitDuration() {
        return this.maxWaitDuration;
    }

    public List<BatchInterceptor> getBatchInterceptors() {
        return this.batchInterceptors;
    }

    public boolean ignoreMessageTarget() {
        return this.ignoreMessageTarget;
    }

    public boolean ignoreSegment() {
        return this.ignoreSegment;
    }

    public Long getMinIndex() {
        return this.minIndex;
    }

    public Long getMaxIndexExclusive() {
        return this.maxIndexExclusive;
    }

    public boolean exclusive() {
        return this.exclusive;
    }

    public boolean passive() {
        return this.passive;
    }

    public Function<Client, String> getTrackerIdFactory() {
        return this.trackerIdFactory;
    }

    public Duration getPurgeDelay() {
        return this.purgeDelay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsumerConfiguration)) {
            return false;
        }
        ConsumerConfiguration other = (ConsumerConfiguration)o;
        if (this.prependApplicationName() != other.prependApplicationName()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getMaxFetchBatchSize() != other.getMaxFetchBatchSize()) {
            return false;
        }
        if (this.ignoreMessageTarget() != other.ignoreMessageTarget()) {
            return false;
        }
        if (this.ignoreSegment() != other.ignoreSegment()) {
            return false;
        }
        if (this.exclusive() != other.exclusive()) {
            return false;
        }
        if (this.passive() != other.passive()) {
            return false;
        }
        Long this$minIndex = this.getMinIndex();
        Long other$minIndex = other.getMinIndex();
        if (this$minIndex == null ? other$minIndex != null : !((Object)this$minIndex).equals(other$minIndex)) {
            return false;
        }
        Long this$maxIndexExclusive = this.getMaxIndexExclusive();
        Long other$maxIndexExclusive = other.getMaxIndexExclusive();
        if (this$maxIndexExclusive == null ? other$maxIndexExclusive != null : !((Object)this$maxIndexExclusive).equals(other$maxIndexExclusive)) {
            return false;
        }
        MessageType this$messageType = this.getMessageType();
        MessageType other$messageType = other.getMessageType();
        if (this$messageType == null ? other$messageType != null : !this$messageType.equals(other$messageType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Predicate<Object> this$handlerFilter = this.getHandlerFilter();
        Predicate<Object> other$handlerFilter = other.getHandlerFilter();
        if (this$handlerFilter == null ? other$handlerFilter != null : !this$handlerFilter.equals(other$handlerFilter)) {
            return false;
        }
        ErrorHandler this$errorHandler = this.getErrorHandler();
        ErrorHandler other$errorHandler = other.getErrorHandler();
        if (this$errorHandler == null ? other$errorHandler != null : !this$errorHandler.equals(other$errorHandler)) {
            return false;
        }
        String this$typeFilter = this.getTypeFilter();
        String other$typeFilter = other.getTypeFilter();
        if (this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter)) {
            return false;
        }
        Duration this$maxWaitDuration = this.getMaxWaitDuration();
        Duration other$maxWaitDuration = other.getMaxWaitDuration();
        if (this$maxWaitDuration == null ? other$maxWaitDuration != null : !((Object)this$maxWaitDuration).equals(other$maxWaitDuration)) {
            return false;
        }
        List<BatchInterceptor> this$batchInterceptors = this.getBatchInterceptors();
        List<BatchInterceptor> other$batchInterceptors = other.getBatchInterceptors();
        if (this$batchInterceptors == null ? other$batchInterceptors != null : !((Object)this$batchInterceptors).equals(other$batchInterceptors)) {
            return false;
        }
        Function<Client, String> this$trackerIdFactory = this.getTrackerIdFactory();
        Function<Client, String> other$trackerIdFactory = other.getTrackerIdFactory();
        if (this$trackerIdFactory == null ? other$trackerIdFactory != null : !this$trackerIdFactory.equals(other$trackerIdFactory)) {
            return false;
        }
        Duration this$purgeDelay = this.getPurgeDelay();
        Duration other$purgeDelay = other.getPurgeDelay();
        return !(this$purgeDelay == null ? other$purgeDelay != null : !((Object)this$purgeDelay).equals(other$purgeDelay));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.prependApplicationName() ? 79 : 97);
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getMaxFetchBatchSize();
        result = result * 59 + (this.ignoreMessageTarget() ? 79 : 97);
        result = result * 59 + (this.ignoreSegment() ? 79 : 97);
        result = result * 59 + (this.exclusive() ? 79 : 97);
        result = result * 59 + (this.passive() ? 79 : 97);
        Long $minIndex = this.getMinIndex();
        result = result * 59 + ($minIndex == null ? 43 : ((Object)$minIndex).hashCode());
        Long $maxIndexExclusive = this.getMaxIndexExclusive();
        result = result * 59 + ($maxIndexExclusive == null ? 43 : ((Object)$maxIndexExclusive).hashCode());
        MessageType $messageType = this.getMessageType();
        result = result * 59 + ($messageType == null ? 43 : $messageType.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Predicate<Object> $handlerFilter = this.getHandlerFilter();
        result = result * 59 + ($handlerFilter == null ? 43 : $handlerFilter.hashCode());
        ErrorHandler $errorHandler = this.getErrorHandler();
        result = result * 59 + ($errorHandler == null ? 43 : $errorHandler.hashCode());
        String $typeFilter = this.getTypeFilter();
        result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
        Duration $maxWaitDuration = this.getMaxWaitDuration();
        result = result * 59 + ($maxWaitDuration == null ? 43 : ((Object)$maxWaitDuration).hashCode());
        List<BatchInterceptor> $batchInterceptors = this.getBatchInterceptors();
        result = result * 59 + ($batchInterceptors == null ? 43 : ((Object)$batchInterceptors).hashCode());
        Function<Client, String> $trackerIdFactory = this.getTrackerIdFactory();
        result = result * 59 + ($trackerIdFactory == null ? 43 : $trackerIdFactory.hashCode());
        Duration $purgeDelay = this.getPurgeDelay();
        result = result * 59 + ($purgeDelay == null ? 43 : ((Object)$purgeDelay).hashCode());
        return result;
    }

    public String toString() {
        return "ConsumerConfiguration(messageType=" + this.getMessageType() + ", name=" + this.getName() + ", prependApplicationName=" + this.prependApplicationName() + ", handlerFilter=" + this.getHandlerFilter() + ", errorHandler=" + this.getErrorHandler() + ", threads=" + this.getThreads() + ", typeFilter=" + this.getTypeFilter() + ", maxFetchBatchSize=" + this.getMaxFetchBatchSize() + ", maxWaitDuration=" + this.getMaxWaitDuration() + ", batchInterceptors=" + this.getBatchInterceptors() + ", ignoreMessageTarget=" + this.ignoreMessageTarget() + ", ignoreSegment=" + this.ignoreSegment() + ", minIndex=" + this.getMinIndex() + ", maxIndexExclusive=" + this.getMaxIndexExclusive() + ", exclusive=" + this.exclusive() + ", passive=" + this.passive() + ", trackerIdFactory=" + this.getTrackerIdFactory() + ", purgeDelay=" + this.getPurgeDelay() + ")";
    }

    public static class Builder {
        private MessageType messageType;
        private String name;
        private boolean prependApplicationName$set;
        private boolean prependApplicationName$value;
        private boolean handlerFilter$set;
        private Predicate<Object> handlerFilter$value;
        private boolean errorHandler$set;
        private ErrorHandler errorHandler$value;
        private boolean threads$set;
        private int threads$value;
        private boolean typeFilter$set;
        private String typeFilter$value;
        private boolean maxFetchBatchSize$set;
        private int maxFetchBatchSize$value;
        private boolean maxWaitDuration$set;
        private Duration maxWaitDuration$value;
        private ArrayList<BatchInterceptor> batchInterceptors;
        private boolean ignoreMessageTarget$set;
        private boolean ignoreMessageTarget$value;
        private boolean ignoreSegment$set;
        private boolean ignoreSegment$value;
        private boolean minIndex$set;
        private Long minIndex$value;
        private boolean maxIndexExclusive$set;
        private Long maxIndexExclusive$value;
        private boolean exclusive$set;
        private boolean exclusive$value;
        private boolean passive$set;
        private boolean passive$value;
        private boolean trackerIdFactory$set;
        private Function<Client, String> trackerIdFactory$value;
        private boolean purgeDelay$set;
        private Duration purgeDelay$value;

        Builder() {
        }

        public Builder messageType(@NonNull MessageType messageType) {
            if (messageType == null) {
                throw new NullPointerException("messageType is marked non-null but is null");
            }
            this.messageType = messageType;
            return this;
        }

        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder prependApplicationName(boolean prependApplicationName) {
            this.prependApplicationName$value = prependApplicationName;
            this.prependApplicationName$set = true;
            return this;
        }

        public Builder handlerFilter(@NonNull Predicate<Object> handlerFilter) {
            if (handlerFilter == null) {
                throw new NullPointerException("handlerFilter is marked non-null but is null");
            }
            this.handlerFilter$value = handlerFilter;
            this.handlerFilter$set = true;
            return this;
        }

        public Builder errorHandler(@NonNull ErrorHandler errorHandler) {
            if (errorHandler == null) {
                throw new NullPointerException("errorHandler is marked non-null but is null");
            }
            this.errorHandler$value = errorHandler;
            this.errorHandler$set = true;
            return this;
        }

        public Builder threads(int threads) {
            this.threads$value = threads;
            this.threads$set = true;
            return this;
        }

        public Builder typeFilter(String typeFilter) {
            this.typeFilter$value = typeFilter;
            this.typeFilter$set = true;
            return this;
        }

        public Builder maxFetchBatchSize(int maxFetchBatchSize) {
            this.maxFetchBatchSize$value = maxFetchBatchSize;
            this.maxFetchBatchSize$set = true;
            return this;
        }

        public Builder maxWaitDuration(@NonNull Duration maxWaitDuration) {
            if (maxWaitDuration == null) {
                throw new NullPointerException("maxWaitDuration is marked non-null but is null");
            }
            this.maxWaitDuration$value = maxWaitDuration;
            this.maxWaitDuration$set = true;
            return this;
        }

        public Builder batchInterceptor(BatchInterceptor batchInterceptor) {
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.add(batchInterceptor);
            return this;
        }

        public Builder batchInterceptors(Collection<? extends BatchInterceptor> batchInterceptors) {
            if (batchInterceptors == null) {
                throw new NullPointerException("batchInterceptors cannot be null");
            }
            if (this.batchInterceptors == null) {
                this.batchInterceptors = new ArrayList();
            }
            this.batchInterceptors.addAll(batchInterceptors);
            return this;
        }

        public Builder clearBatchInterceptors() {
            if (this.batchInterceptors != null) {
                this.batchInterceptors.clear();
            }
            return this;
        }

        public Builder ignoreMessageTarget(boolean ignoreMessageTarget) {
            this.ignoreMessageTarget$value = ignoreMessageTarget;
            this.ignoreMessageTarget$set = true;
            return this;
        }

        public Builder ignoreSegment(boolean ignoreSegment) {
            this.ignoreSegment$value = ignoreSegment;
            this.ignoreSegment$set = true;
            return this;
        }

        public Builder minIndex(Long minIndex) {
            this.minIndex$value = minIndex;
            this.minIndex$set = true;
            return this;
        }

        public Builder maxIndexExclusive(Long maxIndexExclusive) {
            this.maxIndexExclusive$value = maxIndexExclusive;
            this.maxIndexExclusive$set = true;
            return this;
        }

        public Builder exclusive(boolean exclusive) {
            this.exclusive$value = exclusive;
            this.exclusive$set = true;
            return this;
        }

        public Builder passive(boolean passive) {
            this.passive$value = passive;
            this.passive$set = true;
            return this;
        }

        public Builder trackerIdFactory(Function<Client, String> trackerIdFactory) {
            this.trackerIdFactory$value = trackerIdFactory;
            this.trackerIdFactory$set = true;
            return this;
        }

        public Builder purgeDelay(Duration purgeDelay) {
            this.purgeDelay$value = purgeDelay;
            this.purgeDelay$set = true;
            return this;
        }

        public ConsumerConfiguration build() {
            List<BatchInterceptor> batchInterceptors;
            switch (this.batchInterceptors == null ? 0 : this.batchInterceptors.size()) {
                case 0: {
                    batchInterceptors = Collections.emptyList();
                    break;
                }
                case 1: {
                    batchInterceptors = Collections.singletonList(this.batchInterceptors.get(0));
                    break;
                }
                default: {
                    batchInterceptors = Collections.unmodifiableList(new ArrayList<BatchInterceptor>(this.batchInterceptors));
                }
            }
            boolean prependApplicationName$value = this.prependApplicationName$value;
            if (!this.prependApplicationName$set) {
                prependApplicationName$value = ConsumerConfiguration.$default$prependApplicationName();
            }
            Predicate<Object> handlerFilter$value = this.handlerFilter$value;
            if (!this.handlerFilter$set) {
                handlerFilter$value = ConsumerConfiguration.$default$handlerFilter();
            }
            ErrorHandler errorHandler$value = this.errorHandler$value;
            if (!this.errorHandler$set) {
                errorHandler$value = ConsumerConfiguration.$default$errorHandler();
            }
            int threads$value = this.threads$value;
            if (!this.threads$set) {
                threads$value = ConsumerConfiguration.$default$threads();
            }
            String typeFilter$value = this.typeFilter$value;
            if (!this.typeFilter$set) {
                typeFilter$value = ConsumerConfiguration.$default$typeFilter();
            }
            int maxFetchBatchSize$value = this.maxFetchBatchSize$value;
            if (!this.maxFetchBatchSize$set) {
                maxFetchBatchSize$value = ConsumerConfiguration.$default$maxFetchBatchSize();
            }
            Duration maxWaitDuration$value = this.maxWaitDuration$value;
            if (!this.maxWaitDuration$set) {
                maxWaitDuration$value = ConsumerConfiguration.$default$maxWaitDuration();
            }
            boolean ignoreMessageTarget$value = this.ignoreMessageTarget$value;
            if (!this.ignoreMessageTarget$set) {
                ignoreMessageTarget$value = ConsumerConfiguration.$default$ignoreMessageTarget();
            }
            boolean ignoreSegment$value = this.ignoreSegment$value;
            if (!this.ignoreSegment$set) {
                ignoreSegment$value = ConsumerConfiguration.$default$ignoreSegment();
            }
            Long minIndex$value = this.minIndex$value;
            if (!this.minIndex$set) {
                minIndex$value = ConsumerConfiguration.$default$minIndex();
            }
            Long maxIndexExclusive$value = this.maxIndexExclusive$value;
            if (!this.maxIndexExclusive$set) {
                maxIndexExclusive$value = ConsumerConfiguration.$default$maxIndexExclusive();
            }
            boolean exclusive$value = this.exclusive$value;
            if (!this.exclusive$set) {
                exclusive$value = ConsumerConfiguration.$default$exclusive();
            }
            boolean passive$value = this.passive$value;
            if (!this.passive$set) {
                passive$value = ConsumerConfiguration.$default$passive();
            }
            Function<Client, String> trackerIdFactory$value = this.trackerIdFactory$value;
            if (!this.trackerIdFactory$set) {
                trackerIdFactory$value = ConsumerConfiguration.$default$trackerIdFactory();
            }
            Duration purgeDelay$value = this.purgeDelay$value;
            if (!this.purgeDelay$set) {
                purgeDelay$value = ConsumerConfiguration.$default$purgeDelay();
            }
            return new ConsumerConfiguration(this.messageType, this.name, prependApplicationName$value, handlerFilter$value, errorHandler$value, threads$value, typeFilter$value, maxFetchBatchSize$value, maxWaitDuration$value, batchInterceptors, ignoreMessageTarget$value, ignoreSegment$value, minIndex$value, maxIndexExclusive$value, exclusive$value, passive$value, trackerIdFactory$value, purgeDelay$value);
        }

        public String toString() {
            return "ConsumerConfiguration.Builder(messageType=" + this.messageType + ", name=" + this.name + ", prependApplicationName$value=" + this.prependApplicationName$value + ", handlerFilter$value=" + this.handlerFilter$value + ", errorHandler$value=" + this.errorHandler$value + ", threads$value=" + this.threads$value + ", typeFilter$value=" + this.typeFilter$value + ", maxFetchBatchSize$value=" + this.maxFetchBatchSize$value + ", maxWaitDuration$value=" + this.maxWaitDuration$value + ", batchInterceptors=" + this.batchInterceptors + ", ignoreMessageTarget$value=" + this.ignoreMessageTarget$value + ", ignoreSegment$value=" + this.ignoreSegment$value + ", minIndex$value=" + this.minIndex$value + ", maxIndexExclusive$value=" + this.maxIndexExclusive$value + ", exclusive$value=" + this.exclusive$value + ", passive$value=" + this.passive$value + ", trackerIdFactory$value=" + this.trackerIdFactory$value + ", purgeDelay$value=" + this.purgeDelay$value + ")";
        }
    }
}

