/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.handling.Handler;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.common.exception.FunctionalException;
import io.fluxcapacitor.javaclient.common.exception.TechnicalException;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.tracking.BatchProcessingException;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.Tracking;
import io.fluxcapacitor.javaclient.tracking.TrackingException;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerFactory;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTracking
implements Tracking {
    private static final Logger log = LoggerFactory.getLogger(DefaultTracking.class);
    private final Object $lock = new Object[0];
    private final BiPredicate<Class<?>, Executable> handlerFilter = ClientUtils::isTrackingHandler;
    private final MessageType messageType;
    private final ResultGateway resultGateway;
    private final List<ConsumerConfiguration> configurations;
    private final Serializer serializer;
    private final HandlerFactory handlerFactory;
    private final Set<ConsumerConfiguration> startedConfigurations = new HashSet<ConsumerConfiguration>();
    private final Collection<CompletableFuture<?>> outstandingRequests = new CopyOnWriteArrayList();
    private final AtomicReference<Registration> shutdownFunction = new AtomicReference<Registration>(Registration.noOp());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration start(FluxCapacitor fluxCapacitor, List<?> handlers) {
        Object object = this.$lock;
        synchronized (object) {
            return fluxCapacitor.apply(fc -> {
                Map<ConsumerConfiguration, List> consumers = this.assignHandlersToConsumers(handlers).entrySet().stream().flatMap(e -> {
                    List converted = ((List)e.getValue()).stream().flatMap(target -> {
                        if (target instanceof Handler) {
                            return Stream.of((Handler)target);
                        }
                        return this.handlerFactory.createHandler(ReflectionUtils.asInstance((Object)target), ((ConsumerConfiguration)e.getKey()).getName(), this.handlerFilter).stream();
                    }).collect(Collectors.toList());
                    return converted.isEmpty() ? Stream.empty() : Stream.of(new AbstractMap.SimpleEntry((ConsumerConfiguration)e.getKey(), converted));
                }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!Collections.disjoint(consumers.keySet(), this.startedConfigurations)) {
                    throw new TrackingException("Failed to start tracking. Consumers for some handlers have already started tracking.");
                }
                this.startedConfigurations.addAll(consumers.keySet());
                Registration registration = consumers.entrySet().stream().map(e -> this.startTracking((ConsumerConfiguration)e.getKey(), (List)e.getValue(), (FluxCapacitor)fc)).reduce(Registration::merge).orElse(Registration.noOp());
                this.shutdownFunction.updateAndGet(r -> r.merge(registration));
                return registration;
            });
        }
    }

    private Map<ConsumerConfiguration, List<Object>> assignHandlersToConsumers(List<?> handlers) {
        ArrayList unassignedHandlers = new ArrayList(handlers);
        Map<ConsumerConfiguration, List<Object>> assignedHandlers = this.configurations.stream().map(config -> {
            List matches = unassignedHandlers.stream().filter(h -> config.getHandlerFilter().test(h)).collect(Collectors.toList());
            if (config.exclusive()) {
                unassignedHandlers.removeAll(matches);
            }
            return Map.entry(config, matches);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        unassignedHandlers.removeAll(assignedHandlers.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList()));
        unassignedHandlers.forEach(h -> {
            throw new TrackingException(String.format("Failed to find consumer for %s", h));
        });
        return assignedHandlers;
    }

    protected Registration startTracking(ConsumerConfiguration configuration, List<Handler<DeserializingMessage>> handlers, FluxCapacitor fluxCapacitor) {
        return DefaultTracker.start(this.createConsumer(configuration, handlers), configuration, fluxCapacitor);
    }

    protected Consumer<List<SerializedMessage>> createConsumer(ConsumerConfiguration configuration, List<Handler<DeserializingMessage>> handlers) {
        return serializedMessages -> DeserializingMessage.handleBatch(this.serializer.deserializeMessages(serializedMessages.stream(), this.messageType)).forEach(m -> handlers.forEach(h -> this.tryHandle((DeserializingMessage)m, (Handler<DeserializingMessage>)h, configuration)));
    }

    protected void tryHandle(DeserializingMessage message, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        handler.findInvoker((Object)message).ifPresent(h -> {
            try {
                this.handle(message, (HandlerInvoker)h, handler, config);
            }
            catch (BatchProcessingException e) {
                throw new BatchProcessingException(String.format("Handler %s failed to handle a %s", handler, message), e.getCause(), e.getMessageIndex());
            }
            catch (Exception e) {
                try {
                    config.getErrorHandler().handleError(e, String.format("Handler %s failed to handle a %s", handler, message), () -> this.handle(message, (HandlerInvoker)h, handler, config));
                }
                catch (Exception thrown) {
                    throw new BatchProcessingException(message.getIndex());
                }
            }
        });
    }

    protected void handle(DeserializingMessage message, HandlerInvoker h, Handler<DeserializingMessage> handler, ConsumerConfiguration config) {
        Object result;
        Exception exception = null;
        try {
            result = Invocation.performInvocation(() -> ((HandlerInvoker)h).invoke());
        }
        catch (FunctionalException e2) {
            result = e2;
            exception = e2;
        }
        catch (Exception e3) {
            result = new TechnicalException(String.format("Handler %s failed to handle a %s", handler, message), e3);
            exception = e3;
        }
        SerializedMessage serializedMessage = message.getSerializedObject();
        boolean shouldSendResponse = this.shouldSendResponse(h, message, config);
        if (result instanceof CompletableFuture) {
            CompletionStage future = ((CompletableFuture)result).whenComplete((r, e) -> {
                Throwable error = ObjectUtils.unwrapException((Throwable)e);
                Object asyncResult = error == null ? r : (error instanceof FunctionalException ? error : new TechnicalException(String.format("Handler %s failed to handle a %s", handler, message), error));
                message.run(m -> {
                    try {
                        if (shouldSendResponse) {
                            this.resultGateway.respond(asyncResult, serializedMessage.getSource(), serializedMessage.getRequestId());
                        }
                        if (error != null) {
                            config.getErrorHandler().handleError((Exception)error, String.format("Handler %s failed to handle a %s", handler, message), () -> this.handle(message, h, handler, config));
                        }
                    }
                    catch (Exception exc) {
                        log.warn("Did not stop consumer {} after async handler {} failed to handle a {}", new Object[]{config.getName(), handler, message, exc});
                    }
                });
            });
            this.outstandingRequests.add((CompletableFuture<?>)future);
            ((CompletableFuture)future).whenComplete((arg_0, arg_1) -> this.lambda$handle$16((CompletableFuture)future, arg_0, arg_1));
        } else if (shouldSendResponse) {
            this.resultGateway.respond(result, serializedMessage.getSource(), serializedMessage.getRequestId());
        }
        if (exception != null) {
            throw exception;
        }
    }

    private boolean shouldSendResponse(HandlerInvoker invoker, DeserializingMessage message, ConsumerConfiguration config) {
        return message.getSerializedObject().getRequestId() != null && !config.passive() && !invoker.isPassive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.shutdownFunction.get().merge(() -> ClientUtils.waitForResults(Duration.ofSeconds(2L), this.outstandingRequests)).cancel();
        }
    }

    @ConstructorProperties(value={"messageType", "resultGateway", "configurations", "serializer", "handlerFactory"})
    public DefaultTracking(MessageType messageType, ResultGateway resultGateway, List<ConsumerConfiguration> configurations, Serializer serializer, HandlerFactory handlerFactory) {
        this.messageType = messageType;
        this.resultGateway = resultGateway;
        this.configurations = configurations;
        this.serializer = serializer;
        this.handlerFactory = handlerFactory;
    }

    private /* synthetic */ void lambda$handle$16(CompletableFuture future, Object r, Throwable e) {
        this.outstandingRequests.remove(future);
    }
}

