/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackerRead;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class SimpleTrackerRead
implements TrackerRead {
    private final String consumerName;
    private final String trackerId;
    private final Long lastTrackerIndex;
    private final long deadline;
    private final Long purgeDelay;
    private final int maxSize;
    private final Predicate<String> typeFilter;
    private final boolean ignoreMessageTarget;
    private final MessageType messageType;

    public SimpleTrackerRead(String consumer, String trackerId, Long previousLastIndex, ConsumerConfiguration config) {
        this.consumerName = consumer;
        this.trackerId = trackerId;
        this.lastTrackerIndex = previousLastIndex;
        this.deadline = System.currentTimeMillis() + config.getMaxWaitDuration().toMillis();
        this.purgeDelay = Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null);
        this.maxSize = config.getMaxFetchBatchSize();
        this.typeFilter = SimpleTrackerRead.toPredicate(config.getTypeFilter());
        this.ignoreMessageTarget = config.ignoreMessageTarget();
        this.messageType = config.getMessageType();
    }

    private static Predicate<String> toPredicate(String typeFilter) {
        if (typeFilter == null) {
            return s -> true;
        }
        return Pattern.compile(typeFilter).asMatchPredicate();
    }

    @Override
    public boolean canHandle(SerializedMessage message) {
        return message.getData().getType() == null || this.typeFilter.test(message.getData().getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTrackerRead that = (SimpleTrackerRead)o;
        return Objects.equals(this.consumerName, that.consumerName) && Objects.equals(this.trackerId, that.trackerId);
    }

    public int hashCode() {
        return Objects.hash(this.consumerName, this.trackerId);
    }

    public String toString() {
        return "WebSocketTracker{consumerName='" + this.consumerName + "', trackerId='" + this.trackerId + "'}";
    }

    @Override
    public String getConsumerName() {
        return this.consumerName;
    }

    @Override
    public String getTrackerId() {
        return this.trackerId;
    }

    @Override
    public Long getLastTrackerIndex() {
        return this.lastTrackerIndex;
    }

    @Override
    public long getDeadline() {
        return this.deadline;
    }

    @Override
    public Long getPurgeDelay() {
        return this.purgeDelay;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public Predicate<String> getTypeFilter() {
        return this.typeFilter;
    }

    public boolean isIgnoreMessageTarget() {
        return this.ignoreMessageTarget;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }
}

