/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling;

import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.tracking.handling.HasLocalHandlers;
import java.beans.ConstructorProperties;
import java.lang.reflect.Executable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiPredicate;

public interface HandlerRegistry
extends HasLocalHandlers {
    public Optional<CompletableFuture<Message>> handle(DeserializingMessage var1);

    default public HandlerRegistry merge(HandlerRegistry next) {
        return new MergedHandlerRegistry(this, next);
    }

    public static class MergedHandlerRegistry
    implements HandlerRegistry {
        private final HandlerRegistry first;
        private final HandlerRegistry second;

        @Override
        public Optional<CompletableFuture<Message>> handle(DeserializingMessage message) {
            Optional<CompletableFuture<Message>> firstResult = this.first.handle(message);
            Optional<CompletableFuture<Message>> secondResult = this.second.handle(message);
            return firstResult.isPresent() ? secondResult.map(messageCompletableFuture -> ((CompletableFuture)firstResult.get()).thenCombine((CompletionStage)messageCompletableFuture, (a, b) -> a)).or(() -> firstResult) : secondResult;
        }

        @Override
        public Registration registerHandler(Object target) {
            return this.first.registerHandler(target).merge(this.second.registerHandler(target));
        }

        @Override
        public Registration registerHandler(Object target, BiPredicate<Class<?>, Executable> handlerFilter) {
            return this.first.registerHandler(target, handlerFilter).merge(this.second.registerHandler(target, handlerFilter));
        }

        @ConstructorProperties(value={"first", "second"})
        public MergedHandlerRegistry(HandlerRegistry first, HandlerRegistry second) {
            this.first = first;
            this.second = second;
        }
    }
}

