/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserProvider;
import java.beans.ConstructorProperties;
import java.util.Optional;

public abstract class AbstractUserProvider
implements UserProvider {
    private final String metadataKey;
    private final Class<? extends User> userClass;

    public AbstractUserProvider(Class<? extends User> userClass) {
        this("$user", userClass);
    }

    @Override
    public User fromMetadata(Metadata metadata) {
        return Optional.ofNullable((User)metadata.get((Object)this.metadataKey, this.userClass)).orElse(null);
    }

    @Override
    public boolean containsUser(Metadata metadata) {
        return metadata.containsKey((Object)this.metadataKey);
    }

    @Override
    public Metadata removeFromMetadata(Metadata metadata) {
        return metadata.without((Object)this.metadataKey);
    }

    @Override
    public Metadata addToMetadata(Metadata metadata, User user) {
        return metadata.with((Object)this.metadataKey, (Object)user);
    }

    @ConstructorProperties(value={"metadataKey", "userClass"})
    public AbstractUserProvider(String metadataKey, Class<? extends User> userClass) {
        this.metadataKey = metadataKey;
        this.userClass = userClass;
    }
}

