/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.handling.HandlerInvoker;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.HandlerInterceptor;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationUtils;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Validator;
import java.beans.ConstructorProperties;
import java.util.function.Function;

public class ValidatingInterceptor
implements HandlerInterceptor,
DispatchInterceptor {
    private final Validator validator;

    public ValidatingInterceptor() {
        this.validator = ValidationUtils.defaultValidator;
    }

    @Override
    public Message interceptDispatch(Message message, MessageType messageType) {
        ValidationUtils.assertValid(message.getPayload(), this.validator, new Class[0]);
        return message;
    }

    @Override
    public Function<DeserializingMessage, Object> interceptHandling(Function<DeserializingMessage, Object> function, HandlerInvoker invoker, String consumer) {
        return m -> {
            ValidationUtils.assertValid(m.getPayload(), this.validator, new Class[0]);
            return function.apply((DeserializingMessage)m);
        };
    }

    @ConstructorProperties(value={"validator"})
    public ValidatingInterceptor(Validator validator) {
        this.validator = validator;
    }
}

