/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.validation;

import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.handling.HandlerConfiguration;
import io.fluxcapacitor.common.handling.HandlerInspector;
import io.fluxcapacitor.common.handling.HandlerMatcher;
import io.fluxcapacitor.common.handling.Invocation;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.AssertLegal;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.EntityParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.DeserializingMessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MessageParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.MetadataParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.ForbidsRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.NoOpUserProvider;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.RequiresRole;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthenticatedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UnauthorizedException;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.UserParameterResolver;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Jsr380Validator;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidateWith;
import io.fluxcapacitor.javaclient.tracking.handling.validation.ValidationException;
import io.fluxcapacitor.javaclient.tracking.handling.validation.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ValidationUtils {
    public static final Validator defaultValidator = Optional.of(ServiceLoader.load(Validator.class)).map(ServiceLoader::iterator).filter(Iterator::hasNext).map(Iterator::next).orElse(Jsr380Validator.createDefault());
    private static final Function<Class<?>, Class<?>[]> validateWithGroups = ObjectUtils.memoize(type -> {
        ValidateWith annotation = type.getAnnotation(ValidateWith.class);
        if (annotation == null) {
            return new Class[0];
        }
        return annotation.value();
    });
    protected static final Function<Class<?>, HandlerMatcher<Entity<?>>> assertLegalInvokerCache = ObjectUtils.memoize(type -> HandlerInspector.inspect((Class)type, Arrays.asList(new DeserializingMessageParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver(), new UserParameterResolver(NoOpUserProvider.getInstance()), new EntityParameterResolver()), (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(AssertLegal.class).handlerFilter((owner, method) -> ReflectionUtils.getMethodAnnotation((Executable)method, AssertLegal.class).map(a -> !a.afterHandler()).orElse(false)).invokeMultipleMethods(true).build()));
    protected static final Function<Class<?>, HandlerMatcher<Entity<?>>> assertLegalAfterUpdateInvokerCache = ObjectUtils.memoize(type -> HandlerInspector.inspect((Class)type, Arrays.asList(new DeserializingMessageParameterResolver(), new MetadataParameterResolver(), new MessageParameterResolver(), new UserParameterResolver(NoOpUserProvider.getInstance()), new EntityParameterResolver()), (HandlerConfiguration)HandlerConfiguration.builder().methodAnnotation(AssertLegal.class).handlerFilter((owner, method) -> ReflectionUtils.getMethodAnnotation((Executable)method, AssertLegal.class).map(AssertLegal::afterHandler).orElse(false)).invokeMultipleMethods(true).build()));
    private static final Function<Class<?>, String[]> requiredRolesCache = ObjectUtils.memoize(payloadClass -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations((Class)payloadClass)));
    private static final BiFunction<Class<?>, Executable, String[]> requiredRolesForMethodCache = ObjectUtils.memoize((target, executable) -> Optional.ofNullable(ValidationUtils.getRequiredRoles(Arrays.asList(executable.getAnnotations()))).orElseGet(() -> ValidationUtils.getRequiredRoles(ReflectionUtils.getTypeAnnotations((Class)target))));

    public static Optional<ValidationException> checkValidity(Object object, Class<?> ... groups) {
        return ValidationUtils.checkValidity(object, defaultValidator, groups);
    }

    public static boolean isValid(Object object, Class<?> ... groups) {
        return ValidationUtils.isValid(object, defaultValidator, groups);
    }

    public static void assertValid(Object object, Class<?> ... groups) {
        ValidationUtils.assertValid(object, defaultValidator, groups);
    }

    public static Optional<ValidationException> checkValidity(Object object, Validator validator, Class<?> ... groups) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(o -> ValidationUtils.checkValidity(o, validator, groups)).reduce((a, b) -> a.isEmpty() ? b : a).orElse(Optional.empty());
        }
        return validator.checkValidity(object, ValidationUtils.getValidationGroups(object, groups));
    }

    public static boolean isValid(Object object, Validator validator, Class<?> ... groups) {
        if (object instanceof Collection) {
            return ((Collection)object).stream().map(o -> ValidationUtils.isValid(o, validator, groups)).reduce((a, b) -> a != false && b != false).orElse(true);
        }
        return validator.isValid(object, ValidationUtils.getValidationGroups(object, groups));
    }

    public static void assertValid(Object object, Validator validator, Class<?> ... groups) {
        if (object instanceof Iterable) {
            ((Iterable)object).forEach(o -> ValidationUtils.assertValid(o, validator, groups));
        } else {
            validator.assertValid(object, ValidationUtils.getValidationGroups(object, groups));
        }
    }

    private static Class<?>[] getValidationGroups(Object object, Class<?>[] customGroups) {
        if (customGroups.length > 0 || object == null) {
            return customGroups;
        }
        return validateWithGroups.apply(object.getClass());
    }

    public static <E extends Exception> void assertLegal(Object object, Entity<?> entity) throws E {
        Collection<Object> additionalProperties = ValidationUtils.assertLegal(object, entity, assertLegalInvokerCache);
        additionalProperties.forEach(p -> ValidationUtils.assertLegal(p, entity));
        Invocation.whenHandlerCompletes((r, e) -> {
            if (e == null) {
                ValidationUtils.assertLegal(object, entity, assertLegalAfterUpdateInvokerCache);
            }
        });
    }

    private static Collection<Object> assertLegal(Object object, Entity<?> entity, Function<Class<?>, HandlerMatcher<Entity<?>>> invokerProvider) {
        Object payload;
        Object object2 = payload = object instanceof Message ? ((Message)object).getPayload() : object;
        if (payload == null) {
            return Collections.emptyList();
        }
        HandlerMatcher<Entity<?>> invoker = invokerProvider.apply(payload.getClass());
        HashSet<Object> additionalProperties = new HashSet<Object>(ReflectionUtils.getAnnotatedPropertyValues((Object)payload, AssertLegal.class));
        invoker.findInvoker(payload, entity).ifPresent(s -> {
            Object additionalObject = s.invoke();
            if (additionalObject instanceof List) {
                additionalProperties.addAll((List)additionalObject);
            } else if (additionalObject != null) {
                additionalProperties.add(additionalObject);
            }
        });
        entity.possibleTargets(payload).forEach(e -> additionalProperties.addAll(ValidationUtils.assertLegal(payload, e, invokerProvider)));
        return additionalProperties;
    }

    public static <E extends Exception> Optional<E> checkLegality(Object payload, Entity<?> entity) {
        try {
            ValidationUtils.assertLegal(payload, entity);
            return Optional.empty();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    public static boolean isLegal(Object commandOrQuery, Entity<?> entity) {
        return ValidationUtils.checkLegality(commandOrQuery, entity).isEmpty();
    }

    public static void assertAuthorized(Class<?> payloadType, User user) throws UnauthenticatedException, UnauthorizedException {
        String[] requiredRoles = requiredRolesCache.apply(payloadType);
        ValidationUtils.assertAuthorized(payloadType.getSimpleName(), user, requiredRoles);
    }

    public static Optional<Exception> checkAuthorization(Class<?> payloadType, User user) {
        try {
            ValidationUtils.assertAuthorized(payloadType, user);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static boolean isAuthorized(Class<?> payloadType, User user) {
        return ValidationUtils.checkAuthorization(payloadType, user).isEmpty();
    }

    public static boolean isAuthorized(Class<?> target, Executable method, User user) {
        try {
            ValidationUtils.assertAuthorized(method.getName(), user, requiredRolesForMethodCache.apply(target, method));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static void assertAuthorized(String action, User user, String[] requiredRoles) {
        if (requiredRoles != null) {
            if (user == null) {
                throw new UnauthenticatedException(String.format("%s requires authentication", action));
            }
            ArrayList remainingRoles = new ArrayList();
            if (Arrays.stream(requiredRoles).filter(r -> {
                if (r.startsWith("!")) {
                    return true;
                }
                remainingRoles.add(r);
                return false;
            }).anyMatch(r -> user.hasRole(r.substring(1)))) {
                throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
            }
            if (!remainingRoles.isEmpty()) {
                if (remainingRoles.stream().noneMatch(user::hasRole)) {
                    throw new UnauthorizedException(String.format("User %s is unauthorized to execute %s", user.getName(), action));
                }
            }
        }
    }

    protected static String[] getRequiredRoles(Iterable<? extends Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof RequiresRole) {
                return ((RequiresRole)annotation).value();
            }
            if (annotation.annotationType().isAnnotationPresent(RequiresRole.class)) {
                for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                    if (!method.getName().equalsIgnoreCase("value")) continue;
                    Object[] result = (Object[])method.invoke((Object)annotation, new Object[0]);
                    return (String[])Arrays.stream(result).map(Object::toString).toArray(String[]::new);
                }
            }
            if (annotation instanceof ForbidsRole) {
                return (String[])Arrays.stream(((ForbidsRole)annotation).value()).map(s -> "!" + s).toArray(String[]::new);
            }
            if (!annotation.annotationType().isAnnotationPresent(ForbidsRole.class)) continue;
            for (Method method : ReflectionUtils.getAllMethods(annotation.annotationType())) {
                if (!method.getName().equalsIgnoreCase("value")) continue;
                Object[] result = (Object[])method.invoke((Object)annotation, new Object[0]);
                return (String[])Arrays.stream(result).map(Object::toString).map(s -> "!" + s).toArray(String[]::new);
            }
        }
        return null;
    }
}

