/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import java.beans.ConstructorProperties;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public final class WebResponse
extends Message {
    @NonNull
    private final Map<String, List<String>> headers;
    private final Integer status;

    public static Builder builder() {
        return new Builder();
    }

    private WebResponse(Builder builder) {
        super(builder.payload(), Metadata.of((Object[])new Object[]{"status", builder.status(), "headers", builder.headers()}));
        this.status = builder.status();
        this.headers = builder.headers();
    }

    @ConstructorProperties(value={"payload", "metadata", "messageId", "timestamp"})
    WebResponse(Object payload, Metadata metadata, String messageId, Instant timestamp) {
        super(payload, metadata, messageId, timestamp);
        this.headers = Optional.ofNullable((Map)metadata.get((Object)"headers", Map.class)).orElse(Collections.emptyMap());
        this.status = Optional.ofNullable(metadata.get((Object)"status")).map(Integer::valueOf).orElse(null);
    }

    public WebResponse(Message m) {
        this(m.getPayload(), m.getMetadata(), m.getMessageId(), m.getTimestamp());
    }

    @Override
    public SerializedMessage serialize(Serializer serializer) {
        return this.headers.getOrDefault("Content-Type", List.of()).stream().findFirst().map(format -> new SerializedMessage(serializer.serialize(this.getPayload(), (String)format), this.getMetadata(), this.getMessageId(), Long.valueOf(this.getTimestamp().toEpochMilli()))).orElseGet(() -> super.serialize(serializer));
    }

    public static Metadata asMetadata(int statusCode, Map<String, List<String>> headers) {
        return Metadata.of((Object[])new Object[]{"status", statusCode, "headers", headers});
    }

    @Override
    public WebResponse withMetadata(Metadata metadata) {
        return new WebResponse(super.withMetadata(metadata));
    }

    @Override
    public WebResponse withPayload(Object payload) {
        return new WebResponse(super.withPayload(payload));
    }

    public static Map<String, List<String>> getHeaders(Metadata metadata) {
        return Optional.ofNullable((Map)metadata.get((Object)"headers", Map.class)).orElse(Collections.emptyMap());
    }

    public static Integer getStatusCode(Metadata metadata) {
        return Optional.ofNullable(metadata.get((Object)"status")).map(Integer::valueOf).orElse(null);
    }

    @NonNull
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Integer getStatus() {
        return this.status;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebResponse)) {
            return false;
        }
        WebResponse other = (WebResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebResponse(super=" + super.toString() + ", headers=" + this.getHeaders() + ", status=" + this.getStatus() + ")";
    }

    public static class Builder {
        private Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private Object payload;
        private Integer status;

        public Builder payload(Object payload) {
            this.payload = payload;
            if (!this.headers().containsKey("Content-Type")) {
                if (payload instanceof String) {
                    return this.contentType("text/plain");
                }
                if (payload instanceof byte[]) {
                    return this.contentType("application/octet-stream");
                }
            }
            return this;
        }

        public Builder header(String key, String value) {
            this.headers.computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public WebResponse build() {
            return new WebResponse(this);
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public Object payload() {
            return this.payload;
        }

        public Integer status() {
            return this.status;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$status = this.status();
            Integer other$status = other.status();
            if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.headers();
            Map<String, List<String>> other$headers = other.headers();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            Object this$payload = this.payload();
            Object other$payload = other.payload();
            return !(this$payload == null ? other$payload != null : !this$payload.equals(other$payload));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $status = this.status();
            result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
            Map<String, List<String>> $headers = this.headers();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            Object $payload = this.payload();
            result = result * 59 + ($payload == null ? 43 : $payload.hashCode());
            return result;
        }

        public String toString() {
            return "WebResponse.Builder(headers=" + this.headers() + ", payload=" + this.payload() + ", status=" + this.status() + ")";
        }
    }
}

