/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.GivenWhenThenAssertionError;
import io.fluxcapacitor.javaclient.test.TestFixture;
import io.fluxcapacitor.javaclient.test.Then;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultValidator
implements Then {
    private static final Logger log = LoggerFactory.getLogger(ResultValidator.class);
    static final boolean matchersSupported = ReflectionUtils.classExists((String)"org.hamcrest.Matcher");
    private final FluxCapacitor fluxCapacitor;
    private final Object result;
    private final List<Message> events;
    private final List<Message> commands;
    private final List<Message> webRequests;
    private final List<Message> metrics;
    private final List<Schedule> newSchedules;
    private final List<Schedule> allSchedules;
    private final List<Throwable> errors;

    @Override
    public Then expectOnlyEvents(Object ... events) {
        return this.expectOnly(this.asMessages(events), this.events);
    }

    @Override
    public Then expectEvents(Object ... events) {
        return this.expect(this.asMessages(events), this.events);
    }

    @Override
    public Then expectNoEventsLike(Object ... events) {
        return this.expectNothingLike(this.asMessages(events), this.events);
    }

    @Override
    public Then expectOnlyCommands(Object ... commands) {
        return this.expectOnly(this.asMessages(commands), this.commands);
    }

    @Override
    public Then expectCommands(Object ... commands) {
        return this.expect(this.asMessages(commands), this.commands);
    }

    @Override
    public Then expectNoCommandsLike(Object ... commands) {
        return this.expectNothingLike(this.asMessages(commands), this.commands);
    }

    @Override
    public Then expectOnlyNewSchedules(Object ... schedules) {
        return this.expectOnlyScheduledMessages(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then expectNewSchedules(Object ... schedules) {
        return this.expectScheduledMessages(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then expectNoNewSchedulesLike(Object ... schedules) {
        return this.expectNothingLike(this.asMessages(schedules), this.newSchedules);
    }

    @Override
    public Then expectOnlySchedules(Object ... schedules) {
        return this.expectOnlyScheduledMessages(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public Then expectSchedules(Object ... schedules) {
        return this.expectScheduledMessages(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public Then expectNoSchedulesLike(Object ... schedules) {
        return this.expectNothingLike(this.asMessages(schedules), this.allSchedules);
    }

    @Override
    public ResultValidator expectResult(Object expectedResult) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            Object expected = TestFixture.parseObject(expectedResult, callerClass);
            if (this.result instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.result);
            }
            if (!this.matches(expected, this.result)) {
                if (this.isComparableToActual(expected)) {
                    throw new GivenWhenThenAssertionError(String.format("Handler returned a result of unexpected type.\nExpected: %s\nGot: %s", expected.getClass(), this.result.getClass()));
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", expected, this.result);
            }
            return this;
        });
    }

    @Override
    public <T> Then expectResult(Predicate<T> predicate, String description) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            if (this.result instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.result);
            }
            if (!this.testSafely(predicate, this.result)) {
                if (!this.errors.isEmpty()) {
                    throw new GivenWhenThenAssertionError(String.format("Handler returned an unexpected result. Expected: %s\nProbable cause is an exception during handling.", description), this.errors.get(0));
                }
                throw new GivenWhenThenAssertionError("Handler returned an unexpected result", description, this.result);
            }
            return this;
        });
    }

    @Override
    public ResultValidator expectNoResultLike(Object value) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            Object notExpected = TestFixture.parseObject(value, callerClass);
            if (this.result instanceof Throwable) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", (Throwable)this.result);
            }
            if (this.matches(notExpected, this.result)) {
                throw new GivenWhenThenAssertionError(String.format("Handler returned the unwanted result.\nExpected not to get: %s\nGot: %s", notExpected, this.result));
            }
            return this;
        });
    }

    @Override
    @SafeVarargs
    public final <T> Then expectResultContaining(T ... results) {
        if (!(this.result instanceof Collection)) {
            throw new GivenWhenThenAssertionError("Result is not a collection", List.of(results), this.result);
        }
        return this.expect(List.of(results), (Collection)this.result);
    }

    @Override
    public ResultValidator expectExceptionalResult(@NonNull Object expectedException) {
        if (expectedException == null) {
            throw new NullPointerException("expectedException is marked non-null but is null");
        }
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!(this.result instanceof Throwable)) {
                throw new GivenWhenThenAssertionError("Handler returned normally but an exception was expected", expectedException, this.result);
            }
            if (!this.matches(expectedException, this.result)) {
                if (this.isComparableToActual(expectedException)) {
                    throw new GivenWhenThenAssertionError(String.format("Handler threw unexpected exception.\nExpected: %s\nGot: %s", expectedException.getClass(), this.result.getClass()));
                }
                throw new GivenWhenThenAssertionError("Handler threw unexpected exception", expectedException, this.result);
            }
            return this;
        });
    }

    @Override
    public <T extends Throwable> Then expectExceptionalResult(Predicate<T> predicate, String description) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            if (!(this.result instanceof Throwable)) {
                throw new GivenWhenThenAssertionError("Handler returned normally but an exception was expected", description, this.result);
            }
            if (!predicate.test((Throwable)this.result)) {
                throw new GivenWhenThenAssertionError("Handler threw unexpected exception", description, this.result);
            }
            return this;
        });
    }

    @Override
    public Then expectError(Object expectedError) {
        if (this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An error was expected but none was published");
        }
        return this.expect(List.of(expectedError), this.errors);
    }

    @Override
    public <T extends Throwable> Then expectError(Predicate<T> predicate, String description) {
        if (this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An error was expected but none was published");
        }
        try {
            this.expect(List.of(predicate), this.errors);
        }
        catch (GivenWhenThenAssertionError e) {
            throw new GivenWhenThenAssertionError("An unexpected error was published", description, this.result);
        }
        return this;
    }

    @Override
    public Then expectNoErrors() {
        if (!this.errors.isEmpty()) {
            throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", this.errors.get(0));
        }
        return this;
    }

    @Override
    public Then expectMetrics(Object ... metrics) {
        return this.expect(this.asMessages(this.metrics), this.metrics);
    }

    @Override
    public Then expectOnlyMetrics(Object ... metrics) {
        return this.expectOnly(this.asMessages(metrics), this.metrics);
    }

    @Override
    public Then expectNoMetricsLike(Object ... metrics) {
        return this.expectNothingLike(this.asMessages(metrics), this.metrics);
    }

    @Override
    public ResultValidator expectThat(Consumer<FluxCapacitor> check) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            try {
                check.accept((FluxCapacitor)fc);
            }
            catch (Throwable e) {
                if (!this.errors.isEmpty()) {
                    throw new GivenWhenThenAssertionError(String.format("Verify check failed: %s\nProbable cause is an exception during handling.", e.getMessage()), this.errors.get(0));
                }
                throw new GivenWhenThenAssertionError("Verify check failed", e);
            }
            return this;
        });
    }

    @Override
    public Then expectTrue(Predicate<FluxCapacitor> check) {
        return (Then)this.fluxCapacitor.apply(fc -> {
            if (!check.test((FluxCapacitor)fc)) {
                throw new GivenWhenThenAssertionError("Predicate test failed");
            }
            return this;
        });
    }

    protected boolean isComparableToActual(Object expected) {
        return !(this.result == null || expected == null || this.isMatcher(expected) || expected instanceof Collection && this.result instanceof Collection || expected instanceof Map && this.result instanceof Map || Objects.equals(expected.getClass(), this.result.getClass()));
    }

    protected ResultValidator expectScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!expected.isEmpty() && actual.isEmpty()) {
                throw new GivenWhenThenAssertionError("No messages were scheduled");
            }
            expected.forEach(e -> {
                if (e instanceof Schedule && actual.stream().noneMatch(s -> Objects.equals(s.getDeadline(), ((Schedule)e).getDeadline()))) {
                    throw new GivenWhenThenAssertionError(String.format("Found no schedules with matching deadline. Expected %s. Got %s", ((Schedule)e).getDeadline(), actual.stream().map(Schedule::getDeadline).collect(Collectors.toList())));
                }
            });
            return this.expect(this.asMessages(expected), actual);
        });
    }

    protected ResultValidator expect(Collection<?> expected, Collection<?> actual) {
        return (ResultValidator)this.fluxCapacitor.apply(fc -> {
            if (!this.containsAll(expected, actual)) {
                ArrayList remaining = new ArrayList(actual);
                List filtered = expected.stream().flatMap(e -> {
                    if (e != null && !this.isMatcher(expected) && !(expected instanceof Predicate)) {
                        Class<?> payloadType = e instanceof Message ? ((Message)e).getPayload().getClass() : expected.getClass();
                        Object match = remaining.stream().filter(a -> payloadType.equals(a instanceof Message ? ((Message)a).getPayload().getClass() : a.getClass())).findFirst().orElse(null);
                        if (match != null) {
                            remaining.remove(match);
                            return Stream.of(match);
                        }
                    }
                    return Stream.empty();
                }).collect(Collectors.toList());
                this.reportMismatch(expected, filtered.size() == expected.size() ? filtered : actual);
            }
            return this;
        });
    }

    protected ResultValidator expectOnly(Collection<?> expected, Collection<?> actual) {
        if (expected.size() != actual.size()) {
            this.reportMismatch(expected, actual);
        } else if (!this.containsAll(expected, actual)) {
            this.reportMismatch(expected, actual);
        }
        return this;
    }

    protected ResultValidator expectNothingLike(Collection<?> expectedNotToGet, Collection<?> actual) {
        if (this.containsAny(expectedNotToGet, actual)) {
            this.reportUnwantedMatch(expectedNotToGet, actual);
        }
        return this;
    }

    protected void reportMismatch(Collection<?> expected, Collection<?> actual) {
        this.fluxCapacitor.apply(fc -> {
            if (!(this.errors.isEmpty() || !actual.isEmpty() && this.errors.containsAll(actual))) {
                throw new GivenWhenThenAssertionError("Published messages did not match. Probable cause is an exception that occurred during handling", expected, actual, this.errors.get(0));
            }
            throw new GivenWhenThenAssertionError("Published messages did not match", expected, actual);
        });
    }

    protected void reportUnwantedMatch(Collection<?> expected, Collection<?> actual) {
        this.fluxCapacitor.apply(fc -> {
            if (!(this.errors.isEmpty() || !actual.isEmpty() && this.errors.containsAll(actual))) {
                throw new GivenWhenThenAssertionError("An unexpected exception occurred during handling", this.errors.get(0));
            }
            throw new GivenWhenThenAssertionError(String.format("Unwanted match found in published messages.\nExpected not to get: %s\nGot: %s\n\n", expected, actual));
        });
    }

    protected ResultValidator expectOnlyScheduledMessages(Collection<?> expected, Collection<? extends Schedule> actual) {
        ResultValidator result = this.expectScheduledMessages(expected, actual);
        return result.expectOnly(expected, actual);
    }

    protected boolean containsAll(Collection<?> expected, Collection<?> actual) {
        return expected.stream().allMatch(e -> actual.stream().anyMatch(a -> this.matches(e, a)));
    }

    protected boolean containsAny(Collection<?> expected, Collection<?> actual) {
        return expected.stream().anyMatch(e -> actual.stream().anyMatch(a -> this.matches(e, a)));
    }

    protected boolean matches(Object expected, Object actual) {
        if (actual instanceof Message) {
            return this.matches(expected, (Message)actual);
        }
        if (expected instanceof Predicate) {
            return this.testSafely((Predicate)expected, actual);
        }
        if (this.isMatcher(expected)) {
            return ((Matcher)expected).matches(actual);
        }
        if (expected instanceof Class) {
            return actual instanceof Class ? expected.equals(actual) : ((Class)expected).isInstance(actual);
        }
        return Objects.deepEquals(expected, actual);
    }

    protected boolean matches(Object expected, Message actual) {
        if (expected instanceof Predicate) {
            return this.testSafely((Predicate)expected, actual.getPayload()) || this.testSafely((Predicate)expected, actual);
        }
        if (this.isMatcher(expected)) {
            return ((Matcher)expected).matches(actual.getPayload()) || ((Matcher)expected).matches((Object)actual);
        }
        if (expected instanceof Class) {
            return ((Class)expected).isInstance(actual.getPayload());
        }
        Message expectedMessage = Message.asMessage((Object)expected);
        if (actual instanceof Schedule && expected instanceof Schedule && !Objects.equals(((Schedule)expected).getDeadline(), ((Schedule)actual).getDeadline())) {
            return false;
        }
        if (actual instanceof WebRequest && expected instanceof WebRequest && !Objects.equals(((WebRequest)expected).getMethod(), ((WebRequest)actual).getMethod())) {
            return false;
        }
        return expectedMessage.getPayload().equals(actual.getPayload()) && actual.getMetadata().entrySet().containsAll(expectedMessage.getMetadata().entrySet());
    }

    protected Collection<?> asMessages(Object ... expectedMessages) {
        Class callerClass = ReflectionUtils.getCallerClass();
        return (Collection)this.fluxCapacitor.apply(fc -> Arrays.stream(expectedMessages).flatMap(e -> e instanceof Collection ? ((Collection)e).stream() : Stream.of(e)).map(c -> TestFixture.parseObject(c, callerClass)).map(e -> e instanceof Message || e instanceof Predicate || this.isMatcher(e) || e instanceof Class ? e : new Message(e)).collect(Collectors.toList()));
    }

    protected boolean testSafely(Predicate<?> predicate, Object actual) {
        try {
            return predicate.test(actual);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected boolean isMatcher(Object expected) {
        return matchersSupported && expected instanceof Matcher;
    }

    @ConstructorProperties(value={"fluxCapacitor", "result", "events", "commands", "webRequests", "metrics", "newSchedules", "allSchedules", "errors"})
    public ResultValidator(FluxCapacitor fluxCapacitor, Object result, List<Message> events, List<Message> commands, List<Message> webRequests, List<Message> metrics, List<Schedule> newSchedules, List<Schedule> allSchedules, List<Throwable> errors) {
        this.fluxCapacitor = fluxCapacitor;
        this.result = result;
        this.events = events;
        this.commands = commands;
        this.webRequests = webRequests;
        this.metrics = metrics;
        this.newSchedules = newSchedules;
        this.allSchedules = allSchedules;
        this.errors = errors;
    }

    protected FluxCapacitor getFluxCapacitor() {
        return this.fluxCapacitor;
    }
}

