/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.benchmark.AbstractClientBenchmark;
import io.fluxcapacitor.javaclient.configuration.DefaultFluxCapacitor;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.tracking.handling.HandleCommand;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighLevelJavaClientRunner
extends AbstractClientBenchmark {
    private static final Logger log = LoggerFactory.getLogger(HighLevelJavaClientRunner.class);
    private final FluxCapacitor fluxCapacitor;

    public static void main(String[] args) {
        HighLevelJavaClientRunner runner = new HighLevelJavaClientRunner(1000, WebSocketClient.ClientConfig.builder().name("benchmark-" + UUID.randomUUID()).projectId("benchmark").serviceBaseUrl("https://flux-capacitor.sloppy.zone").build());
        runner.testCommands();
        System.exit(0);
    }

    public HighLevelJavaClientRunner(int commandCount) {
        super(commandCount);
        this.fluxCapacitor = DefaultFluxCapacitor.builder().build((Client)WebSocketClient.newInstance((WebSocketClient.ClientConfig)this.getClientConfig()));
        this.fluxCapacitor.registerHandlers(new Object[]{this});
    }

    public HighLevelJavaClientRunner(int commandCount, WebSocketClient.ClientConfig clientConfig) {
        super(commandCount, clientConfig);
        this.fluxCapacitor = DefaultFluxCapacitor.builder().build((Client)WebSocketClient.newInstance((WebSocketClient.ClientConfig)clientConfig));
        this.fluxCapacitor.registerHandlers(new Object[]{this});
    }

    @Override
    protected void doSendCommand(String payload) {
        this.fluxCapacitor.commandGateway().sendAndForget((Object)payload);
    }

    @HandleCommand(passive=true)
    public void handleCommand(String command) {
        this.getCommandCountDownLatch().countDown();
    }
}

