/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.test;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.modeling.Id;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.test.When;
import io.fluxcapacitor.javaclient.tracking.handling.authentication.User;
import io.fluxcapacitor.javaclient.web.WebRequest;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;

public interface Given
extends When {
    public Given givenCommands(Object ... var1);

    public Given givenCommandsByUser(User var1, Object ... var2);

    default public Given givenAppliedEvents(Id<?> aggregateId, Object ... events) {
        return this.givenAppliedEvents(aggregateId.toString(), aggregateId.getType(), events);
    }

    public Given givenAppliedEvents(String var1, Class<?> var2, Object ... var3);

    public Given givenEvents(Object ... var1);

    default public Given givenDocument(Object document, String collection) {
        return this.givenDocument(document, UUID.randomUUID().toString(), collection);
    }

    default public Given givenDocument(Object document, String id, String collection) {
        return this.givenDocument(document, id, collection, null);
    }

    default public Given givenDocument(Object document, String id, String collection, Instant timestamp) {
        return this.givenDocument(document, id, collection, timestamp, timestamp);
    }

    public Given givenDocument(Object var1, String var2, String var3, Instant var4, Instant var5);

    public Given givenDocuments(String var1, Object ... var2);

    default public Given givenSchedules(Schedule ... schedules) {
        return this.given(fc -> Arrays.stream(schedules).forEach(s -> fc.scheduler().schedule(s)));
    }

    default public Given givenScheduledCommands(Schedule ... commands) {
        return this.given(fc -> Arrays.stream(commands).forEach(s -> fc.scheduler().scheduleCommand(s)));
    }

    default public Given givenExpiredSchedules(Object ... schedules) {
        return this.givenSchedules((Schedule[])Arrays.stream(schedules).map(p -> new Schedule(p, UUID.randomUUID().toString(), this.getCurrentTime())).toArray(Schedule[]::new));
    }

    public Given givenTimeAdvancedTo(Instant var1);

    public Given givenElapsedTime(Duration var1);

    public Given givenWebRequest(WebRequest var1);

    public Given given(Consumer<FluxCapacitor> var1);

    public Clock getClock();

    default public Instant getCurrentTime() {
        return this.getClock().instant();
    }

    public Given withClock(Clock var1);

    public Given atFixedTime(Instant var1);
}

