/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.serialization;

import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.SerializedObject;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import java.util.function.Function;

public class DeserializingObject<T, S extends SerializedObject<T, S>> {
    private final S serializedObject;
    private final MemoizingFunction<Class<?>, Object> objectFunction;

    public S getSerializedObject() {
        return this.serializedObject;
    }

    protected MemoizingFunction<Class<?>, Object> getObjectFunction() {
        return this.objectFunction;
    }

    public DeserializingObject(S serializedObject, Function<Class<?>, Object> payload) {
        this.serializedObject = serializedObject;
        this.objectFunction = ObjectUtils.memoize(payload);
    }

    public <V> V getPayload() {
        return (V)this.objectFunction.apply(Object.class);
    }

    public <V> V getPayloadAs(Class<V> type) {
        return (V)this.objectFunction.apply(type);
    }

    public boolean isDeserialized() {
        return this.objectFunction.isCached(Object.class);
    }

    public String getType() {
        return this.serializedObject.data().getType();
    }

    public int getRevision() {
        return this.serializedObject.data().getRevision();
    }

    public Class<?> getPayloadClass() {
        String type = this.getType();
        return type == null ? null : ReflectionUtils.classForName((String)type);
    }

    public String toString() {
        return "DeserializingObject(serializedObject=" + String.valueOf(this.getSerializedObject()) + ")";
    }
}

