/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.common.websocket;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ServicePathBuilder;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;

public class ServiceUrlBuilder {
    public static String producerUrl(MessageType messageType, WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.producerPath((MessageType)messageType));
    }

    public static String consumerUrl(MessageType messageType, WebSocketClient.ClientConfig clientConfig) {
        Object url = ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.consumerPath((MessageType)messageType));
        if (clientConfig.getTypeFilter() != null) {
            url = (String)url + "&typeFilter=" + clientConfig.getTypeFilter();
        }
        return url;
    }

    public static String eventSourcingUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.eventSourcingPath());
    }

    public static String keyValueUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.keyValuePath());
    }

    public static String searchUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.searchPath());
    }

    public static String schedulingUrl(WebSocketClient.ClientConfig clientConfig) {
        return ServiceUrlBuilder.buildUrl(clientConfig, ServicePathBuilder.schedulingPath());
    }

    public static String buildUrl(WebSocketClient.ClientConfig clientConfig, String path) {
        String result = String.format("%s/%s?clientId=%s&clientName=%s", clientConfig.getServiceBaseUrl(), path, clientConfig.getId(), clientConfig.getName());
        if (clientConfig.getProjectId() != null) {
            result = String.format("%s&projectId=%s", result, clientConfig.getProjectId());
        }
        if (clientConfig.getCompression() != null) {
            result = String.format("%s&compression=%s", result, clientConfig.getCompression());
        }
        return result;
    }
}

