/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration;

import io.fluxcapacitor.common.application.DefaultPropertySource;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import java.util.Optional;

public class ApplicationProperties {
    public static String getProperty(String name) {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::propertySource).orElseGet(DefaultPropertySource::getInstance).get(name);
    }

    public static boolean getBooleanProperty(String name) {
        return ApplicationProperties.getBooleanProperty(name, false);
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).map("true"::equalsIgnoreCase).orElse(defaultValue);
    }

    public static Integer getIntegerProperty(String name) {
        return ApplicationProperties.getIntegerProperty(name, null);
    }

    public static Integer getIntegerProperty(String name, Integer defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).map(Integer::valueOf).orElse(defaultValue);
    }

    public static String getProperty(String name, String defaultValue) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).orElse(defaultValue);
    }

    public static String requireProperty(String name) {
        return Optional.ofNullable(ApplicationProperties.getProperty(name)).orElseThrow(() -> new IllegalStateException(String.format("Property for %s is missing", name)));
    }

    public static boolean containsProperty(String name) {
        return ApplicationProperties.getProperty(name) != null;
    }

    public static String substituteProperties(String template) {
        return FluxCapacitor.getOptionally().map(FluxCapacitor::propertySource).orElseGet(DefaultPropertySource::getInstance).substituteProperties(template);
    }

    public static String encryptValue(String value) {
        return DefaultPropertySource.getInstance().getEncryption().encrypt(value);
    }
}

