/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.serialization.compression.CompressionAlgorithm;
import io.fluxcapacitor.javaclient.common.websocket.ServiceUrlBuilder;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.WebSocketEventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.WebsocketKeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.persisting.search.client.WebSocketSearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.client.WebsocketGatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.WebsocketSchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.CachingTrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.WebsocketTrackingClient;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;

public class WebSocketClient
extends AbstractClient {
    private final ClientConfig clientConfig;

    public static WebSocketClient newInstance(ClientConfig clientConfig) {
        return new WebSocketClient(clientConfig);
    }

    protected WebSocketClient(ClientConfig clientConfig) {
        super(clientConfig.getName(), clientConfig.getId());
        this.clientConfig = clientConfig;
    }

    @Override
    protected GatewayClient createGatewayClient(MessageType messageType) {
        return new WebsocketGatewayClient(ServiceUrlBuilder.producerUrl(messageType, this.clientConfig), this, messageType);
    }

    @Override
    protected TrackingClient createTrackingClient(MessageType messageType) {
        TrackingClientConfig trackingConfig = this.clientConfig.getTrackingConfigs().get(messageType);
        WebsocketTrackingClient wsClient = new WebsocketTrackingClient(ServiceUrlBuilder.consumerUrl(messageType, this.clientConfig), this, messageType);
        return trackingConfig.getCacheSize() > 0 ? new CachingTrackingClient(wsClient, trackingConfig.getCacheSize()) : wsClient;
    }

    @Override
    protected EventStoreClient createEventStoreClient() {
        return new WebSocketEventStoreClient(ServiceUrlBuilder.eventSourcingUrl(this.clientConfig), this);
    }

    @Override
    protected SchedulingClient createSchedulingClient() {
        return new WebsocketSchedulingClient(ServiceUrlBuilder.schedulingUrl(this.clientConfig), this);
    }

    @Override
    protected KeyValueClient createKeyValueClient() {
        return new WebsocketKeyValueClient(ServiceUrlBuilder.keyValueUrl(this.clientConfig), this);
    }

    @Override
    protected SearchClient createSearchClient() {
        return new WebSocketSearchClient(ServiceUrlBuilder.searchUrl(this.clientConfig), this);
    }

    @Override
    public void shutDown() {
        super.shutDown();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public static final class ClientConfig {
        @NonNull
        private final String serviceBaseUrl;
        @NonNull
        private final String name;
        @NonNull
        private final String id;
        @NonNull
        private final CompressionAlgorithm compression;
        private final int eventSourcingSessions;
        private final int keyValueSessions;
        private final int searchSessions;
        private final Map<MessageType, Integer> gatewaySessions;
        private final Map<MessageType, TrackingClientConfig> trackingConfigs;
        private final Duration pingTimeout;
        private final Duration pingDelay;
        private final boolean disableMetrics;
        private final String projectId;
        private final String typeFilter;

        public ClientConfig withGatewaySessions(MessageType messageType, int count) {
            HashMap<MessageType, Integer> config = new HashMap<MessageType, Integer>(this.gatewaySessions);
            config.put(messageType, count);
            return this.toBuilder().gatewaySessions(config).build();
        }

        public ClientConfig withTrackingConfig(MessageType messageType, TrackingClientConfig trackingConfig) {
            HashMap<MessageType, TrackingClientConfig> config = new HashMap<MessageType, TrackingClientConfig>(this.trackingConfigs);
            config.put(messageType, trackingConfig);
            return this.toBuilder().trackingConfigs(config).build();
        }

        private static Map<MessageType, Integer> defaultGatewaySessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> 1));
        }

        private static Map<MessageType, TrackingClientConfig> defaultTrackingSessions() {
            return Arrays.stream(MessageType.values()).collect(Collectors.toMap(Function.identity(), t -> t == MessageType.RESULT ? TrackingClientConfig.builder().cacheSize(0).build() : TrackingClientConfig.builder().build()));
        }

        private static String $default$id() {
            return UUID.randomUUID().toString();
        }

        private static CompressionAlgorithm $default$compression() {
            return CompressionAlgorithm.LZ4;
        }

        private static int $default$eventSourcingSessions() {
            return 2;
        }

        private static int $default$keyValueSessions() {
            return 2;
        }

        private static int $default$searchSessions() {
            return 2;
        }

        private static Map<MessageType, Integer> $default$gatewaySessions() {
            return ClientConfig.defaultGatewaySessions();
        }

        private static Map<MessageType, TrackingClientConfig> $default$trackingConfigs() {
            return ClientConfig.defaultTrackingSessions();
        }

        private static Duration $default$pingTimeout() {
            return Duration.ofSeconds(10L);
        }

        private static Duration $default$pingDelay() {
            return Duration.ofMinutes(1L);
        }

        @ConstructorProperties(value={"serviceBaseUrl", "name", "id", "compression", "eventSourcingSessions", "keyValueSessions", "searchSessions", "gatewaySessions", "trackingConfigs", "pingTimeout", "pingDelay", "disableMetrics", "projectId", "typeFilter"})
        ClientConfig(@NonNull String serviceBaseUrl, @NonNull String name, @NonNull String id, @NonNull CompressionAlgorithm compression, int eventSourcingSessions, int keyValueSessions, int searchSessions, Map<MessageType, Integer> gatewaySessions, Map<MessageType, TrackingClientConfig> trackingConfigs, Duration pingTimeout, Duration pingDelay, boolean disableMetrics, String projectId, String typeFilter) {
            if (serviceBaseUrl == null) {
                throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
            }
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            if (compression == null) {
                throw new NullPointerException("compression is marked non-null but is null");
            }
            this.serviceBaseUrl = serviceBaseUrl;
            this.name = name;
            this.id = id;
            this.compression = compression;
            this.eventSourcingSessions = eventSourcingSessions;
            this.keyValueSessions = keyValueSessions;
            this.searchSessions = searchSessions;
            this.gatewaySessions = gatewaySessions;
            this.trackingConfigs = trackingConfigs;
            this.pingTimeout = pingTimeout;
            this.pingDelay = pingDelay;
            this.disableMetrics = disableMetrics;
            this.projectId = projectId;
            this.typeFilter = typeFilter;
        }

        public static ClientConfigBuilder builder() {
            return new ClientConfigBuilder();
        }

        public ClientConfigBuilder toBuilder() {
            return new ClientConfigBuilder().serviceBaseUrl(this.serviceBaseUrl).name(this.name).id(this.id).compression(this.compression).eventSourcingSessions(this.eventSourcingSessions).keyValueSessions(this.keyValueSessions).searchSessions(this.searchSessions).gatewaySessions(this.gatewaySessions).trackingConfigs(this.trackingConfigs).pingTimeout(this.pingTimeout).pingDelay(this.pingDelay).disableMetrics(this.disableMetrics).projectId(this.projectId).typeFilter(this.typeFilter);
        }

        @NonNull
        public String getServiceBaseUrl() {
            return this.serviceBaseUrl;
        }

        @NonNull
        public String getName() {
            return this.name;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @NonNull
        public CompressionAlgorithm getCompression() {
            return this.compression;
        }

        public int getEventSourcingSessions() {
            return this.eventSourcingSessions;
        }

        public int getKeyValueSessions() {
            return this.keyValueSessions;
        }

        public int getSearchSessions() {
            return this.searchSessions;
        }

        public Map<MessageType, Integer> getGatewaySessions() {
            return this.gatewaySessions;
        }

        public Map<MessageType, TrackingClientConfig> getTrackingConfigs() {
            return this.trackingConfigs;
        }

        public Duration getPingTimeout() {
            return this.pingTimeout;
        }

        public Duration getPingDelay() {
            return this.pingDelay;
        }

        public boolean isDisableMetrics() {
            return this.disableMetrics;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getTypeFilter() {
            return this.typeFilter;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfig)) {
                return false;
            }
            ClientConfig other = (ClientConfig)o;
            if (this.getEventSourcingSessions() != other.getEventSourcingSessions()) {
                return false;
            }
            if (this.getKeyValueSessions() != other.getKeyValueSessions()) {
                return false;
            }
            if (this.getSearchSessions() != other.getSearchSessions()) {
                return false;
            }
            if (this.isDisableMetrics() != other.isDisableMetrics()) {
                return false;
            }
            String this$serviceBaseUrl = this.getServiceBaseUrl();
            String other$serviceBaseUrl = other.getServiceBaseUrl();
            if (this$serviceBaseUrl == null ? other$serviceBaseUrl != null : !this$serviceBaseUrl.equals(other$serviceBaseUrl)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            CompressionAlgorithm this$compression = this.getCompression();
            CompressionAlgorithm other$compression = other.getCompression();
            if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
                return false;
            }
            Map<MessageType, Integer> this$gatewaySessions = this.getGatewaySessions();
            Map<MessageType, Integer> other$gatewaySessions = other.getGatewaySessions();
            if (this$gatewaySessions == null ? other$gatewaySessions != null : !((Object)this$gatewaySessions).equals(other$gatewaySessions)) {
                return false;
            }
            Map<MessageType, TrackingClientConfig> this$trackingConfigs = this.getTrackingConfigs();
            Map<MessageType, TrackingClientConfig> other$trackingConfigs = other.getTrackingConfigs();
            if (this$trackingConfigs == null ? other$trackingConfigs != null : !((Object)this$trackingConfigs).equals(other$trackingConfigs)) {
                return false;
            }
            Duration this$pingTimeout = this.getPingTimeout();
            Duration other$pingTimeout = other.getPingTimeout();
            if (this$pingTimeout == null ? other$pingTimeout != null : !((Object)this$pingTimeout).equals(other$pingTimeout)) {
                return false;
            }
            Duration this$pingDelay = this.getPingDelay();
            Duration other$pingDelay = other.getPingDelay();
            if (this$pingDelay == null ? other$pingDelay != null : !((Object)this$pingDelay).equals(other$pingDelay)) {
                return false;
            }
            String this$projectId = this.getProjectId();
            String other$projectId = other.getProjectId();
            if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
                return false;
            }
            String this$typeFilter = this.getTypeFilter();
            String other$typeFilter = other.getTypeFilter();
            return !(this$typeFilter == null ? other$typeFilter != null : !this$typeFilter.equals(other$typeFilter));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEventSourcingSessions();
            result = result * 59 + this.getKeyValueSessions();
            result = result * 59 + this.getSearchSessions();
            result = result * 59 + (this.isDisableMetrics() ? 79 : 97);
            String $serviceBaseUrl = this.getServiceBaseUrl();
            result = result * 59 + ($serviceBaseUrl == null ? 43 : $serviceBaseUrl.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            CompressionAlgorithm $compression = this.getCompression();
            result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
            Map<MessageType, Integer> $gatewaySessions = this.getGatewaySessions();
            result = result * 59 + ($gatewaySessions == null ? 43 : ((Object)$gatewaySessions).hashCode());
            Map<MessageType, TrackingClientConfig> $trackingConfigs = this.getTrackingConfigs();
            result = result * 59 + ($trackingConfigs == null ? 43 : ((Object)$trackingConfigs).hashCode());
            Duration $pingTimeout = this.getPingTimeout();
            result = result * 59 + ($pingTimeout == null ? 43 : ((Object)$pingTimeout).hashCode());
            Duration $pingDelay = this.getPingDelay();
            result = result * 59 + ($pingDelay == null ? 43 : ((Object)$pingDelay).hashCode());
            String $projectId = this.getProjectId();
            result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
            String $typeFilter = this.getTypeFilter();
            result = result * 59 + ($typeFilter == null ? 43 : $typeFilter.hashCode());
            return result;
        }

        public String toString() {
            return "WebSocketClient.ClientConfig(serviceBaseUrl=" + this.getServiceBaseUrl() + ", name=" + this.getName() + ", id=" + this.getId() + ", compression=" + String.valueOf(this.getCompression()) + ", eventSourcingSessions=" + this.getEventSourcingSessions() + ", keyValueSessions=" + this.getKeyValueSessions() + ", searchSessions=" + this.getSearchSessions() + ", gatewaySessions=" + String.valueOf(this.getGatewaySessions()) + ", trackingConfigs=" + String.valueOf(this.getTrackingConfigs()) + ", pingTimeout=" + String.valueOf(this.getPingTimeout()) + ", pingDelay=" + String.valueOf(this.getPingDelay()) + ", disableMetrics=" + this.isDisableMetrics() + ", projectId=" + this.getProjectId() + ", typeFilter=" + this.getTypeFilter() + ")";
        }

        public static class ClientConfigBuilder {
            private String serviceBaseUrl;
            private String name;
            private boolean id$set;
            private String id$value;
            private boolean compression$set;
            private CompressionAlgorithm compression$value;
            private boolean eventSourcingSessions$set;
            private int eventSourcingSessions$value;
            private boolean keyValueSessions$set;
            private int keyValueSessions$value;
            private boolean searchSessions$set;
            private int searchSessions$value;
            private boolean gatewaySessions$set;
            private Map<MessageType, Integer> gatewaySessions$value;
            private boolean trackingConfigs$set;
            private Map<MessageType, TrackingClientConfig> trackingConfigs$value;
            private boolean pingTimeout$set;
            private Duration pingTimeout$value;
            private boolean pingDelay$set;
            private Duration pingDelay$value;
            private boolean disableMetrics;
            private String projectId;
            private String typeFilter;

            ClientConfigBuilder() {
            }

            public ClientConfigBuilder serviceBaseUrl(@NonNull String serviceBaseUrl) {
                if (serviceBaseUrl == null) {
                    throw new NullPointerException("serviceBaseUrl is marked non-null but is null");
                }
                this.serviceBaseUrl = serviceBaseUrl;
                return this;
            }

            public ClientConfigBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            public ClientConfigBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id$value = id;
                this.id$set = true;
                return this;
            }

            public ClientConfigBuilder compression(@NonNull CompressionAlgorithm compression) {
                if (compression == null) {
                    throw new NullPointerException("compression is marked non-null but is null");
                }
                this.compression$value = compression;
                this.compression$set = true;
                return this;
            }

            public ClientConfigBuilder eventSourcingSessions(int eventSourcingSessions) {
                this.eventSourcingSessions$value = eventSourcingSessions;
                this.eventSourcingSessions$set = true;
                return this;
            }

            public ClientConfigBuilder keyValueSessions(int keyValueSessions) {
                this.keyValueSessions$value = keyValueSessions;
                this.keyValueSessions$set = true;
                return this;
            }

            public ClientConfigBuilder searchSessions(int searchSessions) {
                this.searchSessions$value = searchSessions;
                this.searchSessions$set = true;
                return this;
            }

            public ClientConfigBuilder gatewaySessions(Map<MessageType, Integer> gatewaySessions) {
                this.gatewaySessions$value = gatewaySessions;
                this.gatewaySessions$set = true;
                return this;
            }

            public ClientConfigBuilder trackingConfigs(Map<MessageType, TrackingClientConfig> trackingConfigs) {
                this.trackingConfigs$value = trackingConfigs;
                this.trackingConfigs$set = true;
                return this;
            }

            public ClientConfigBuilder pingTimeout(Duration pingTimeout) {
                this.pingTimeout$value = pingTimeout;
                this.pingTimeout$set = true;
                return this;
            }

            public ClientConfigBuilder pingDelay(Duration pingDelay) {
                this.pingDelay$value = pingDelay;
                this.pingDelay$set = true;
                return this;
            }

            public ClientConfigBuilder disableMetrics(boolean disableMetrics) {
                this.disableMetrics = disableMetrics;
                return this;
            }

            public ClientConfigBuilder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public ClientConfigBuilder typeFilter(String typeFilter) {
                this.typeFilter = typeFilter;
                return this;
            }

            public ClientConfig build() {
                String id$value = this.id$value;
                if (!this.id$set) {
                    id$value = ClientConfig.$default$id();
                }
                CompressionAlgorithm compression$value = this.compression$value;
                if (!this.compression$set) {
                    compression$value = ClientConfig.$default$compression();
                }
                int eventSourcingSessions$value = this.eventSourcingSessions$value;
                if (!this.eventSourcingSessions$set) {
                    eventSourcingSessions$value = ClientConfig.$default$eventSourcingSessions();
                }
                int keyValueSessions$value = this.keyValueSessions$value;
                if (!this.keyValueSessions$set) {
                    keyValueSessions$value = ClientConfig.$default$keyValueSessions();
                }
                int searchSessions$value = this.searchSessions$value;
                if (!this.searchSessions$set) {
                    searchSessions$value = ClientConfig.$default$searchSessions();
                }
                Map<MessageType, Integer> gatewaySessions$value = this.gatewaySessions$value;
                if (!this.gatewaySessions$set) {
                    gatewaySessions$value = ClientConfig.$default$gatewaySessions();
                }
                Map<MessageType, TrackingClientConfig> trackingConfigs$value = this.trackingConfigs$value;
                if (!this.trackingConfigs$set) {
                    trackingConfigs$value = ClientConfig.$default$trackingConfigs();
                }
                Duration pingTimeout$value = this.pingTimeout$value;
                if (!this.pingTimeout$set) {
                    pingTimeout$value = ClientConfig.$default$pingTimeout();
                }
                Duration pingDelay$value = this.pingDelay$value;
                if (!this.pingDelay$set) {
                    pingDelay$value = ClientConfig.$default$pingDelay();
                }
                return new ClientConfig(this.serviceBaseUrl, this.name, id$value, compression$value, eventSourcingSessions$value, keyValueSessions$value, searchSessions$value, gatewaySessions$value, trackingConfigs$value, pingTimeout$value, pingDelay$value, this.disableMetrics, this.projectId, this.typeFilter);
            }

            public String toString() {
                return "WebSocketClient.ClientConfig.ClientConfigBuilder(serviceBaseUrl=" + this.serviceBaseUrl + ", name=" + this.name + ", id$value=" + this.id$value + ", compression$value=" + String.valueOf(this.compression$value) + ", eventSourcingSessions$value=" + this.eventSourcingSessions$value + ", keyValueSessions$value=" + this.keyValueSessions$value + ", searchSessions$value=" + this.searchSessions$value + ", gatewaySessions$value=" + String.valueOf(this.gatewaySessions$value) + ", trackingConfigs$value=" + String.valueOf(this.trackingConfigs$value) + ", pingTimeout$value=" + String.valueOf(this.pingTimeout$value) + ", pingDelay$value=" + String.valueOf(this.pingDelay$value) + ", disableMetrics=" + this.disableMetrics + ", projectId=" + this.projectId + ", typeFilter=" + this.typeFilter + ")";
            }
        }
    }

    public static final class TrackingClientConfig {
        private final int sessions;
        private final int cacheSize;

        private static int $default$sessions() {
            return 1;
        }

        private static int $default$cacheSize() {
            return 0;
        }

        @ConstructorProperties(value={"sessions", "cacheSize"})
        TrackingClientConfig(int sessions, int cacheSize) {
            this.sessions = sessions;
            this.cacheSize = cacheSize;
        }

        public static TrackingClientConfigBuilder builder() {
            return new TrackingClientConfigBuilder();
        }

        public TrackingClientConfigBuilder toBuilder() {
            return new TrackingClientConfigBuilder().sessions(this.sessions).cacheSize(this.cacheSize);
        }

        public int getSessions() {
            return this.sessions;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TrackingClientConfig)) {
                return false;
            }
            TrackingClientConfig other = (TrackingClientConfig)o;
            if (this.getSessions() != other.getSessions()) {
                return false;
            }
            return this.getCacheSize() == other.getCacheSize();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSessions();
            result = result * 59 + this.getCacheSize();
            return result;
        }

        public String toString() {
            return "WebSocketClient.TrackingClientConfig(sessions=" + this.getSessions() + ", cacheSize=" + this.getCacheSize() + ")";
        }

        public static class TrackingClientConfigBuilder {
            private boolean sessions$set;
            private int sessions$value;
            private boolean cacheSize$set;
            private int cacheSize$value;

            TrackingClientConfigBuilder() {
            }

            public TrackingClientConfigBuilder sessions(int sessions) {
                this.sessions$value = sessions;
                this.sessions$set = true;
                return this;
            }

            public TrackingClientConfigBuilder cacheSize(int cacheSize) {
                this.cacheSize$value = cacheSize;
                this.cacheSize$set = true;
                return this;
            }

            public TrackingClientConfig build() {
                int sessions$value = this.sessions$value;
                if (!this.sessions$set) {
                    sessions$value = TrackingClientConfig.$default$sessions();
                }
                int cacheSize$value = this.cacheSize$value;
                if (!this.cacheSize$set) {
                    cacheSize$value = TrackingClientConfig.$default$cacheSize();
                }
                return new TrackingClientConfig(sessions$value, cacheSize$value);
            }

            public String toString() {
                return "WebSocketClient.TrackingClientConfig.TrackingClientConfigBuilder(sessions$value=" + this.sessions$value + ", cacheSize$value=" + this.cacheSize$value + ")";
            }
        }
    }
}

