/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.modeling.Entity;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class NoOpEntity<T>
implements Entity<T> {
    private final Supplier<Entity<T>> loader;
    private final AtomicReference<Object> delegate = new AtomicReference();

    private NoOpEntity(Entity<T> delegate) {
        this.loader = () -> delegate;
    }

    @Override
    public NoOpEntity<T> apply(Message eventMessage) {
        return this;
    }

    @Override
    public Entity<T> update(UnaryOperator<T> function) {
        return this;
    }

    @Override
    public <E extends Exception> NoOpEntity<T> assertLegal(Object command) throws E {
        return this;
    }

    @Override
    public <E extends Exception> NoOpEntity<T> assertThat(Entity.Validator<T, E> validator) throws E {
        return this;
    }

    @Override
    public <E extends Exception> NoOpEntity<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        return this;
    }

    @Override
    public Entity<?> parent() {
        return Optional.ofNullable(this.delegate().parent()).map(NoOpEntity::new).orElse(null);
    }

    @Override
    public Collection<?> aliases() {
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends Entity<?>> entities() {
        return this.delegate().entities().stream().map(e -> new NoOpEntity(e)).collect(Collectors.toList());
    }

    @Override
    public Entity<T> previous() {
        return new NoOpEntity<T>(this.delegate().previous());
    }

    @Override
    public Object id() {
        return this.delegate().id();
    }

    @Override
    public Class<T> type() {
        return this.delegate().type();
    }

    @Override
    public Entity<T> withType(Class<T> type) {
        return this.delegate().withType(type);
    }

    @Override
    public T get() {
        return this.delegate().get();
    }

    @Override
    public String idProperty() {
        return this.delegate().idProperty();
    }

    @ConstructorProperties(value={"loader"})
    public NoOpEntity(Supplier<Entity<T>> loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entity<T> delegate() {
        Object value = this.delegate.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.delegate;
            synchronized (atomicReference) {
                value = this.delegate.get();
                if (value == null) {
                    Entity<T> actualValue = this.loader.get();
                    value = actualValue == null ? this.delegate : actualValue;
                    this.delegate.set(value);
                }
            }
        }
        return (Entity)(value == this.delegate ? null : value);
    }
}

