/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.publishing;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.publishing.DispatchInterceptor;
import io.fluxcapacitor.javaclient.publishing.GatewayException;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import java.beans.ConstructorProperties;
import java.util.concurrent.CompletableFuture;

public class DefaultResultGateway
implements ResultGateway {
    private final GatewayClient client;
    private final Serializer serializer;
    private final DispatchInterceptor dispatchInterceptor;

    @Override
    public CompletableFuture<Void> respond(Object payload, Metadata metadata, String target, Integer requestId, Guarantee guarantee) {
        try {
            SerializedMessage serializedMessage = this.interceptDispatch(payload, metadata);
            if (serializedMessage == null) {
                return CompletableFuture.completedFuture(null);
            }
            serializedMessage.setTarget(target);
            serializedMessage.setRequestId(requestId);
            return this.client.append(guarantee, serializedMessage);
        }
        catch (Exception e) {
            throw new GatewayException(String.format("Failed to send response %s", payload), e);
        }
    }

    protected SerializedMessage interceptDispatch(Object payload, Metadata metadata) {
        SerializedMessage serializedMessage;
        Message message = this.dispatchInterceptor.interceptDispatch(new Message(payload, metadata), MessageType.RESULT);
        SerializedMessage serializedMessage2 = serializedMessage = message == null ? null : this.dispatchInterceptor.modifySerializedMessage(message.serialize(this.serializer), message, MessageType.RESULT);
        if (serializedMessage != null) {
            this.dispatchInterceptor.monitorDispatch(message, MessageType.RESULT);
        }
        return serializedMessage;
    }

    @ConstructorProperties(value={"client", "serializer", "dispatchInterceptor"})
    public DefaultResultGateway(GatewayClient client, Serializer serializer, DispatchInterceptor dispatchInterceptor) {
        this.client = client;
        this.serializer = serializer;
        this.dispatchInterceptor = dispatchInterceptor;
    }
}

