/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.scheduling.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.scheduling.SerializedSchedule;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.common.serialization.Serializer;
import io.fluxcapacitor.javaclient.scheduling.Schedule;
import io.fluxcapacitor.javaclient.scheduling.client.InMemoryScheduleStore;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.LocalTrackingClient;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class LocalSchedulingClient
extends LocalTrackingClient
implements SchedulingClient {
    public LocalSchedulingClient(Duration messageExpiration) {
        super(new InMemoryScheduleStore(messageExpiration), MessageType.SCHEDULE);
    }

    @Override
    public InMemoryScheduleStore getMessageStore() {
        return (InMemoryScheduleStore)super.getMessageStore();
    }

    public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.getMessageStore().append(messages);
    }

    @Override
    public CompletableFuture<Void> schedule(Guarantee guarantee, SerializedSchedule ... schedules) {
        return this.getMessageStore().schedule(guarantee, schedules);
    }

    @Override
    public CompletableFuture<Void> cancelSchedule(String scheduleId, Guarantee guarantee) {
        return this.getMessageStore().cancelSchedule(scheduleId, guarantee);
    }

    @Override
    public SerializedSchedule getSchedule(String scheduleId) {
        return this.getMessageStore().getSchedule(scheduleId);
    }

    public CompletableFuture<Void> append(List<SerializedMessage> messages) {
        return this.getMessageStore().append(messages);
    }

    public void setClock(Clock clock) {
        this.getMessageStore().setClock(clock);
    }

    public List<Schedule> getSchedules(Serializer serializer) {
        return this.getMessageStore().getSchedules(serializer);
    }

    public List<Schedule> removeExpiredSchedules(Serializer serializer) {
        return this.getMessageStore().removeExpiredSchedules(serializer);
    }

    public List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        return this.getMessageStore().getBatch(minIndex, maxSize, inclusive);
    }

    public void notifyMonitors() {
        this.getMessageStore().notifyMonitors();
    }

    public void notifyMonitors(List<SerializedMessage> messages) {
        this.getMessageStore().notifyMonitors(messages);
    }

    @Override
    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.getMessageStore().registerMonitor(monitor);
    }

    @Override
    public void close() {
        this.getMessageStore().close();
    }

    @Override
    public MessageType getMessageType() {
        return this.getMessageStore().getMessageType();
    }

    public Duration getMessageExpiration() {
        return this.getMessageStore().getMessageExpiration();
    }

    public List<SerializedMessage> getBatch(Long minIndex, int maxSize) {
        return this.getMessageStore().getBatch(minIndex, maxSize);
    }

    public <T extends MessageStore> T unwrap(Class<T> type) {
        return (T)this.getMessageStore().unwrap(type);
    }

    @Override
    public CompletableFuture<Void> schedule(SerializedSchedule ... schedules) {
        return this.getMessageStore().schedule(schedules);
    }

    @Override
    public CompletableFuture<Void> cancelSchedule(String scheduleId) {
        return this.getMessageStore().cancelSchedule(scheduleId);
    }
}

