/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.ClaimSegment;
import io.fluxcapacitor.common.api.tracking.ClaimSegmentResult;
import io.fluxcapacitor.common.api.tracking.DisconnectTracker;
import io.fluxcapacitor.common.api.tracking.GetPosition;
import io.fluxcapacitor.common.api.tracking.GetPositionResult;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.api.tracking.ReadFromIndex;
import io.fluxcapacitor.common.api.tracking.ReadFromIndexResult;
import io.fluxcapacitor.common.api.tracking.ReadResult;
import io.fluxcapacitor.common.api.tracking.ResetPosition;
import io.fluxcapacitor.common.api.tracking.StorePosition;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@ClientEndpoint
public class WebsocketTrackingClient
extends AbstractWebsocketClient
implements TrackingClient {
    private final MessageType messageType;
    private final Metadata metricsMetadata;

    public WebsocketTrackingClient(String endPointUrl, WebSocketClient client, MessageType type) {
        this(URI.create(endPointUrl), client, type);
    }

    public WebsocketTrackingClient(URI endPointUri, WebSocketClient client, MessageType type) {
        this(endPointUri, client, type, type != MessageType.METRICS);
    }

    public WebsocketTrackingClient(URI endPointUri, WebSocketClient client, MessageType type, boolean sendMetrics) {
        super(endPointUri, client, sendMetrics, client.getClientConfig().getTrackingConfigs().get(type).getSessions());
        this.messageType = type;
        this.metricsMetadata = Metadata.of((Object)"messageType", (Object)type);
    }

    @Override
    public CompletableFuture<MessageBatch> read(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration configuration) {
        return this.send((Request)new Read(this.messageType, consumer, trackerId, configuration.getMaxFetchSize(), configuration.getMaxWaitDuration().toMillis(), configuration.getTypeFilter(), configuration.filterMessageTarget(), configuration.ignoreSegment(), configuration.singleTracker(), configuration.clientControlledIndex(), lastIndex, (Long)Optional.ofNullable(configuration.getPurgeDelay()).map(Duration::toMillis).orElse(null))).thenApply(ReadResult::getMessageBatch);
    }

    public CompletableFuture<ClaimSegmentResult> claimSegment(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration config) {
        return this.send((Request)new ClaimSegment(this.messageType, consumer, trackerId, config.getMaxWaitDuration().toMillis(), config.clientControlledIndex(), config.getTypeFilter(), config.filterMessageTarget(), lastIndex, (Long)Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null)));
    }

    @Override
    public List<SerializedMessage> readFromIndex(long minIndex, int maxSize) {
        ReadFromIndexResult result = (ReadFromIndexResult)this.sendAndWait((Request)new ReadFromIndex(this.messageType, minIndex, maxSize));
        return result.getMessages();
    }

    @Override
    public CompletableFuture<Void> storePosition(String consumer, int[] segment, long lastIndex, Guarantee guarantee) {
        return this.sendCommand((Command)new StorePosition(this.messageType, consumer, segment, lastIndex, guarantee));
    }

    @Override
    public CompletableFuture<Void> resetPosition(String consumer, long lastIndex, Guarantee guarantee) {
        return this.sendCommand((Command)new ResetPosition(this.messageType, consumer, lastIndex, guarantee));
    }

    @Override
    public Position getPosition(String consumer) {
        return ((GetPositionResult)this.sendAndWait((Request)new GetPosition(this.messageType, consumer))).getPosition();
    }

    @Override
    public CompletableFuture<Void> disconnectTracker(String consumer, String trackerId, boolean sendFinalEmptyBatch, Guarantee guarantee) {
        return this.sendCommand((Command)new DisconnectTracker(this.messageType, consumer, trackerId, sendFinalEmptyBatch, guarantee));
    }

    @Override
    protected Metadata metricsMetadata() {
        return this.metricsMetadata;
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public String toString() {
        return "%s-%s".formatted(super.toString(), this.messageType);
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    public Metadata getMetricsMetadata() {
        return this.metricsMetadata;
    }
}

