/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.handling.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.fluxcapacitor.common.ThrowingRunnable;
import java.security.Principal;
import java.util.concurrent.Callable;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface User
extends Principal {
    public static final ThreadLocal<User> current = new ThreadLocal();

    public static <U extends User> U getCurrent() {
        return (U)current.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public <T> T apply(Callable<T> f) {
        Object previousUser = User.getCurrent();
        try {
            current.set(this);
            T t = f.call();
            return t;
        }
        finally {
            current.set((User)previousUser);
        }
    }

    default public void run(ThrowingRunnable f) {
        this.apply(() -> {
            f.run();
            return null;
        });
    }

    public boolean hasRole(String var1);
}

