/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.publishing.ResultGateway;
import io.fluxcapacitor.javaclient.web.SocketSession;
import java.util.concurrent.CompletableFuture;

public record DefaultSocketSession(String sessionId, String target, ResultGateway webResponseGateway) implements SocketSession
{
    @Override
    public CompletableFuture<Void> sendMessage(Object value, Guarantee guarantee) {
        return this.sendMessage(Message.asMessage(value).addMetadata("function", (Object)"message"), guarantee);
    }

    @Override
    public CompletableFuture<Void> sendPing(Object value, Guarantee guarantee) {
        return this.sendMessage(Message.asMessage(value).addMetadata("function", (Object)"ping"), guarantee);
    }

    @Override
    public CompletableFuture<Void> close(int code, Guarantee guarantee) {
        if (code < 1000 || code > 4999) {
            throw new IllegalArgumentException("Invalid code: " + code);
        }
        return this.sendMessage(Message.asMessage(String.valueOf(code)).addMetadata("function", (Object)"close"), guarantee);
    }

    CompletableFuture<Void> sendMessage(Message message, Guarantee guarantee) {
        return this.webResponseGateway.respond(message.getPayload(), message.getMetadata().with((Object)"sessionId", (Object)this.sessionId), this.target, null, guarantee);
    }
}

