/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.Data;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.publishing.correlation.DefaultCorrelationDataProvider;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.DefaultTracker;
import io.fluxcapacitor.javaclient.web.LocalServerConfig;
import io.fluxcapacitor.javaclient.web.WebRequest;
import io.fluxcapacitor.javaclient.web.WebResponse;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingWebConsumer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ForwardingWebConsumer.class);
    private final Object $lock = new Object[0];
    private final String host;
    private final LocalServerConfig localServerConfig;
    private final ConsumerConfiguration configuration;
    private final HttpClient httpClient;
    private final AtomicReference<Registration> registration = new AtomicReference();

    public ForwardingWebConsumer(LocalServerConfig localServerConfig, ConsumerConfiguration configuration) {
        this.host = "http://localhost:" + localServerConfig.getPort();
        this.localServerConfig = localServerConfig;
        this.configuration = configuration;
        this.httpClient = HttpClient.newHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(FluxCapacitor fluxCapacitor) {
        Object object = this.$lock;
        synchronized (object) {
            this.close();
            GatewayClient gatewayClient = fluxCapacitor.client().getGatewayClient(MessageType.WEBRESPONSE);
            BiConsumer<SerializedMessage, SerializedMessage> gateway = (request, response) -> {
                response.setTarget(request.getSource());
                response.setRequestId(request.getRequestId());
                response.setMetadata(response.getMetadata().with(FluxCapacitor.currentCorrelationData()));
                gatewayClient.append(Guarantee.NONE, (SerializedMessage)response);
            };
            Consumer<List> consumer = messages -> messages.forEach(m -> {
                Map<String, String> correlationData = this.getCorrelationData((SerializedMessage)m);
                try {
                    HttpRequest request = this.createRequest((SerializedMessage)m);
                    this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((r, e) -> {
                        if (e == null && r.statusCode() == 404 && this.localServerConfig.isIgnore404()) {
                            return;
                        }
                        gateway.accept((SerializedMessage)m, e == null ? this.toMessage((HttpResponse<byte[]>)r, correlationData) : this.toMessage((Throwable)e, correlationData));
                    });
                }
                catch (Exception e2) {
                    try {
                        gateway.accept((SerializedMessage)m, this.toMessage(e2, correlationData));
                    }
                    catch (Exception e22) {
                        log.error("Failed to create response message from exception", (Throwable)e22);
                    }
                }
            });
            this.registration.getAndUpdate(r -> r == null ? DefaultTracker.start((Consumer<List<SerializedMessage>>)consumer, MessageType.WEBREQUEST, this.configuration, fluxCapacitor) : r);
        }
    }

    protected Map<String, String> getCorrelationData(SerializedMessage m) {
        try {
            return FluxCapacitor.getOptionally().map(FluxCapacitor::correlationDataProvider).orElse(DefaultCorrelationDataProvider.INSTANCE).getCorrelationData(new DeserializingMessage(m, type -> null, MessageType.WEBRESPONSE));
        }
        catch (Exception e) {
            log.error("Failed to get correlation data for request message", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    protected HttpRequest createRequest(SerializedMessage m) {
        try {
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(new URI(this.host + WebRequest.getUrl(m.getMetadata()))).method(WebRequest.getMethod(m.getMetadata()).name(), ((byte[])m.getData().getValue()).length == 0 ? HttpRequest.BodyPublishers.noBody() : HttpRequest.BodyPublishers.ofByteArray((byte[])m.getData().getValue()));
            String[] headers = (String[])WebRequest.getHeaders(m.getMetadata()).entrySet().stream().filter(e -> !this.isRestricted((String)e.getKey())).flatMap(e -> ((List)e.getValue()).stream().flatMap(v -> Stream.of((String)e.getKey(), v))).toArray(String[]::new);
            if (headers.length > 0) {
                builder.headers(headers);
            }
            if (m.getData().getFormat() != null) {
                builder.header("Content-Type", m.getData().getFormat());
            }
            return builder.build();
        }
        catch (Exception e2) {
            throw new IllegalStateException("Failed to create HttpRequest", e2);
        }
    }

    protected boolean isRestricted(String headerName) {
        return Set.of("connection", "content-length", "expect", "host", "upgrade").contains(headerName.toLowerCase());
    }

    protected SerializedMessage toMessage(HttpResponse<byte[]> response, Map<String, String> correlationData) {
        HttpHeaders headers = response.headers();
        Metadata metadata = Metadata.of(correlationData).with(WebResponse.asMetadata(response.statusCode(), headers.map()));
        return new SerializedMessage(new Data((Object)response.body(), null, 0, (String)headers.firstValue("content-type").orElse(null)), metadata, FluxCapacitor.generateId(), Long.valueOf(System.currentTimeMillis()));
    }

    protected SerializedMessage toMessage(Throwable error, Map<String, String> correlationData) {
        log.error("Failed to handle web request: " + error.getMessage() + ". Continuing with next request.", error);
        return new SerializedMessage(new Data((Object)"The request failed due to a server error".getBytes(), null, 0, "text/plain"), Metadata.of(correlationData).with(WebResponse.asMetadata(500, Collections.emptyMap())), FluxCapacitor.generateId(), Long.valueOf(System.currentTimeMillis()));
    }

    @Override
    public void close() {
        this.registration.getAndUpdate(r -> {
            if (r != null) {
                r.cancel();
            }
            return null;
        });
    }
}

