/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import io.fluxcapacitor.javaclient.web.HttpVersion;
import java.beans.ConstructorProperties;
import java.time.Duration;

public final class WebRequestSettings {
    private final HttpVersion httpVersion;
    private final Duration timeout;
    private final String consumer;

    private static HttpVersion $default$httpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    private static Duration $default$timeout() {
        return Duration.ofMinutes(1L);
    }

    private static String $default$consumer() {
        return "reverse-proxy";
    }

    @ConstructorProperties(value={"httpVersion", "timeout", "consumer"})
    WebRequestSettings(HttpVersion httpVersion, Duration timeout, String consumer) {
        this.httpVersion = httpVersion;
        this.timeout = timeout;
        this.consumer = consumer;
    }

    public static WebRequestSettingsBuilder builder() {
        return new WebRequestSettingsBuilder();
    }

    public WebRequestSettingsBuilder toBuilder() {
        return new WebRequestSettingsBuilder().httpVersion(this.httpVersion).timeout(this.timeout).consumer(this.consumer);
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public String getConsumer() {
        return this.consumer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebRequestSettings)) {
            return false;
        }
        WebRequestSettings other = (WebRequestSettings)o;
        HttpVersion this$httpVersion = this.getHttpVersion();
        HttpVersion other$httpVersion = other.getHttpVersion();
        if (this$httpVersion == null ? other$httpVersion != null : !((Object)((Object)this$httpVersion)).equals((Object)other$httpVersion)) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$consumer = this.getConsumer();
        String other$consumer = other.getConsumer();
        return !(this$consumer == null ? other$consumer != null : !this$consumer.equals(other$consumer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpVersion $httpVersion = this.getHttpVersion();
        result = result * 59 + ($httpVersion == null ? 43 : ((Object)((Object)$httpVersion)).hashCode());
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $consumer = this.getConsumer();
        result = result * 59 + ($consumer == null ? 43 : $consumer.hashCode());
        return result;
    }

    public String toString() {
        return "WebRequestSettings(httpVersion=" + String.valueOf((Object)this.getHttpVersion()) + ", timeout=" + String.valueOf(this.getTimeout()) + ", consumer=" + this.getConsumer() + ")";
    }

    public static class WebRequestSettingsBuilder {
        private boolean httpVersion$set;
        private HttpVersion httpVersion$value;
        private boolean timeout$set;
        private Duration timeout$value;
        private boolean consumer$set;
        private String consumer$value;

        WebRequestSettingsBuilder() {
        }

        public WebRequestSettingsBuilder httpVersion(HttpVersion httpVersion) {
            this.httpVersion$value = httpVersion;
            this.httpVersion$set = true;
            return this;
        }

        public WebRequestSettingsBuilder timeout(Duration timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        public WebRequestSettingsBuilder consumer(String consumer) {
            this.consumer$value = consumer;
            this.consumer$set = true;
            return this;
        }

        public WebRequestSettings build() {
            HttpVersion httpVersion$value = this.httpVersion$value;
            if (!this.httpVersion$set) {
                httpVersion$value = WebRequestSettings.$default$httpVersion();
            }
            Duration timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = WebRequestSettings.$default$timeout();
            }
            String consumer$value = this.consumer$value;
            if (!this.consumer$set) {
                consumer$value = WebRequestSettings.$default$consumer();
            }
            return new WebRequestSettings(httpVersion$value, timeout$value, consumer$value);
        }

        public String toString() {
            return "WebRequestSettings.WebRequestSettingsBuilder(httpVersion$value=" + String.valueOf((Object)this.httpVersion$value) + ", timeout$value=" + String.valueOf(this.timeout$value) + ", consumer$value=" + this.consumer$value + ")";
        }
    }
}

