/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MemoizingFunction;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.javaclient.common.ClientUtils;
import io.fluxcapacitor.javaclient.configuration.client.Client;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Client {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private final String name;
    private final String id;
    private final MemoizingFunction<MessageType, ? extends GatewayClient> gatewayClients = ObjectUtils.memoize(this::createGatewayClient);
    private final MemoizingFunction<MessageType, ? extends TrackingClient> trackingClients = ObjectUtils.memoize(this::createTrackingClient);
    private final AtomicReference<Object> eventStoreClient = new AtomicReference();
    private final AtomicReference<Object> schedulingClient = new AtomicReference();
    private final AtomicReference<Object> keyValueClient = new AtomicReference();
    private final AtomicReference<Object> searchClient = new AtomicReference();
    protected final Set<Runnable> shutdownTasks = new CopyOnWriteArraySet<Runnable>();

    public AbstractClient(String name, String id) {
        this.name = name;
        this.id = id;
    }

    protected abstract GatewayClient createGatewayClient(MessageType var1);

    protected abstract TrackingClient createTrackingClient(MessageType var1);

    protected abstract EventStoreClient createEventStoreClient();

    protected abstract SchedulingClient createSchedulingClient();

    protected abstract KeyValueClient createKeyValueClient();

    protected abstract SearchClient createSearchClient();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public GatewayClient getGatewayClient(MessageType messageType) {
        return (GatewayClient)this.gatewayClients.apply((Object)messageType);
    }

    @Override
    public TrackingClient getTrackingClient(MessageType messageType) {
        return (TrackingClient)this.trackingClients.apply((Object)messageType);
    }

    @Override
    public void shutDown() {
        this.shutdownTasks.forEach(ClientUtils::tryRun);
        MessageType[] types = MessageType.values();
        Arrays.stream(types).filter(arg_0 -> this.trackingClients.isCached(arg_0)).map(this.trackingClients).forEach(TrackingClient::close);
        Arrays.stream(types).filter(arg_0 -> this.gatewayClients.isCached(arg_0)).map(this.gatewayClients).forEach(GatewayClient::close);
        this.getEventStoreClient().close();
        this.getSchedulingClient().close();
        this.getKeyValueClient().close();
        this.getSearchClient().close();
    }

    @Override
    public Registration beforeShutdown(Runnable task) {
        this.shutdownTasks.add(task);
        return () -> this.shutdownTasks.remove(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventStoreClient getEventStoreClient() {
        Object value = this.eventStoreClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.eventStoreClient;
            synchronized (atomicReference) {
                value = this.eventStoreClient.get();
                if (value == null) {
                    EventStoreClient actualValue = this.createEventStoreClient();
                    value = actualValue == null ? this.eventStoreClient : actualValue;
                    this.eventStoreClient.set(value);
                }
            }
        }
        return (EventStoreClient)(value == this.eventStoreClient ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchedulingClient getSchedulingClient() {
        Object value = this.schedulingClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.schedulingClient;
            synchronized (atomicReference) {
                value = this.schedulingClient.get();
                if (value == null) {
                    SchedulingClient actualValue = this.createSchedulingClient();
                    value = actualValue == null ? this.schedulingClient : actualValue;
                    this.schedulingClient.set(value);
                }
            }
        }
        return (SchedulingClient)(value == this.schedulingClient ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyValueClient getKeyValueClient() {
        Object value = this.keyValueClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.keyValueClient;
            synchronized (atomicReference) {
                value = this.keyValueClient.get();
                if (value == null) {
                    KeyValueClient actualValue = this.createKeyValueClient();
                    value = actualValue == null ? this.keyValueClient : actualValue;
                    this.keyValueClient.set(value);
                }
            }
        }
        return (KeyValueClient)(value == this.keyValueClient ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchClient getSearchClient() {
        Object value = this.searchClient.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.searchClient;
            synchronized (atomicReference) {
                value = this.searchClient.get();
                if (value == null) {
                    SearchClient actualValue = this.createSearchClient();
                    value = actualValue == null ? this.searchClient : actualValue;
                    this.searchClient.set(value);
                }
            }
        }
        return (SearchClient)(value == this.searchClient ? null : value);
    }
}

