/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.configuration.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.javaclient.configuration.client.AbstractClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.LocalEventStoreClient;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.InMemoryKeyValueStore;
import io.fluxcapacitor.javaclient.persisting.keyvalue.client.KeyValueClient;
import io.fluxcapacitor.javaclient.persisting.search.client.InMemorySearchStore;
import io.fluxcapacitor.javaclient.persisting.search.client.SearchClient;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.scheduling.client.LocalSchedulingClient;
import io.fluxcapacitor.javaclient.scheduling.client.SchedulingClient;
import io.fluxcapacitor.javaclient.tracking.client.LocalTrackingClient;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.lang.management.ManagementFactory;
import java.time.Duration;

public class InMemoryClient
extends AbstractClient {
    private final Duration messageExpiration;
    private final LocalEventStoreClient eventStore;
    private final LocalSchedulingClient scheduleStore;

    public static InMemoryClient newInstance() {
        return new InMemoryClient(Duration.ofMinutes(2L));
    }

    public static InMemoryClient newInstance(Duration messageExpiration) {
        return new InMemoryClient(messageExpiration);
    }

    protected InMemoryClient(Duration messageExpiration) {
        this("inMemory", ManagementFactory.getRuntimeMXBean().getName(), messageExpiration);
    }

    protected InMemoryClient(String name, String id, Duration messageExpiration) {
        super(name, id);
        this.messageExpiration = messageExpiration;
        this.eventStore = new LocalEventStoreClient(messageExpiration);
        this.scheduleStore = new LocalSchedulingClient(messageExpiration);
    }

    @Override
    protected GatewayClient createGatewayClient(MessageType messageType) {
        return switch (messageType) {
            case MessageType.NOTIFICATION, MessageType.EVENT -> this.eventStore;
            case MessageType.SCHEDULE -> this.scheduleStore;
            default -> new LocalTrackingClient(messageType, this.messageExpiration);
        };
    }

    @Override
    protected TrackingClient createTrackingClient(MessageType messageType) {
        return (TrackingClient)((Object)this.getGatewayClient(messageType));
    }

    @Override
    protected EventStoreClient createEventStoreClient() {
        return (EventStoreClient)((Object)this.getTrackingClient(MessageType.EVENT));
    }

    @Override
    protected SchedulingClient createSchedulingClient() {
        return (SchedulingClient)((Object)this.getTrackingClient(MessageType.SCHEDULE));
    }

    @Override
    protected KeyValueClient createKeyValueClient() {
        return new InMemoryKeyValueStore();
    }

    @Override
    protected SearchClient createSearchClient() {
        return new InMemorySearchStore();
    }
}

