/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fluxcapacitor.common.api.HasMetadata;
import io.fluxcapacitor.common.api.Metadata;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.common.Message;
import io.fluxcapacitor.javaclient.common.serialization.DeserializingMessage;
import io.fluxcapacitor.javaclient.modeling.Aggregate;
import io.fluxcapacitor.javaclient.modeling.DefaultEntityHelper;
import io.fluxcapacitor.javaclient.publishing.routing.RoutingKey;
import java.beans.Transient;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface Entity<T> {
    public static final ThreadLocal<Boolean> loading = ThreadLocal.withInitial(() -> false);
    public static final ThreadLocal<Boolean> applying = ThreadLocal.withInitial(() -> false);
    public static final String AGGREGATE_ID_METADATA_KEY = "$aggregateId";
    public static final String AGGREGATE_TYPE_METADATA_KEY = "$aggregateType";
    public static final String AGGREGATE_SN_METADATA_KEY = "$sequenceNumber";

    public static boolean isLoading() {
        return loading.get();
    }

    public static boolean isApplying() {
        return applying.get();
    }

    public static String getAggregateId(HasMetadata message) {
        return message.getMetadata().get((Object)AGGREGATE_ID_METADATA_KEY);
    }

    public static Class<?> getAggregateType(HasMetadata message) {
        return Optional.ofNullable(message.getMetadata().get((Object)AGGREGATE_TYPE_METADATA_KEY)).map(c -> ReflectionUtils.classForName((String)c, null)).orElse(null);
    }

    public static Long getSequenceNumber(HasMetadata message) {
        return Optional.ofNullable(message.getMetadata().get((Object)AGGREGATE_SN_METADATA_KEY)).map(Long::parseLong).orElse(null);
    }

    public Object id();

    public Class<T> type();

    public Entity<T> withType(Class<T> var1);

    public T get();

    @Transient
    default public boolean isEmpty() {
        return this.get() == null;
    }

    @Transient
    default public boolean isPresent() {
        return this.get() != null;
    }

    default public Entity<T> ifPresent(UnaryOperator<Entity<T>> action) {
        if (this.get() == null) {
            return this;
        }
        return (Entity)action.apply(this);
    }

    default public <U> Optional<U> mapIfPresent(Function<Entity<T>, U> action) {
        if (this.get() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(action.apply(this));
    }

    public String idProperty();

    public Entity<?> parent();

    default public <A> A ancestorValue(Class<A> ancestorType) {
        for (Entity<?> ancestor = this; ancestor != null; ancestor = ancestor.parent()) {
            if (!ancestorType.isAssignableFrom(ancestor.type())) continue;
            return ancestorType.cast(ancestor.get());
        }
        return null;
    }

    public Collection<?> aliases();

    @JsonIgnore
    default public boolean isRoot() {
        return this.parent() == null;
    }

    default public Entity<?> root() {
        return Optional.ofNullable(this.parent()).map(Entity::root).orElse(this);
    }

    default public String lastEventId() {
        return this.root().lastEventId();
    }

    default public Long lastEventIndex() {
        return this.root().lastEventIndex();
    }

    default public Long highestEventIndex() {
        return Optional.ofNullable(this.lastEventIndex()).or(() -> Optional.ofNullable(this.previous()).map(Entity::highestEventIndex)).orElse(null);
    }

    default public Entity<T> withEventIndex(Long index, String messageId) {
        return this.root().withEventIndex(index, messageId).findEntity(this.id(), this.type());
    }

    default public Entity<T> withSequenceNumber(long sequenceNumber) {
        return this.root().withSequenceNumber(sequenceNumber).findEntity(this.id(), this.type());
    }

    default public Instant timestamp() {
        return this.root().timestamp();
    }

    default public long sequenceNumber() {
        return this.root().sequenceNumber();
    }

    default public Aggregate rootAnnotation() {
        return DefaultEntityHelper.getRootAnnotation(this.root().type());
    }

    default public Entity<T> previous() {
        return this.root().previous().findEntity(this.id(), this.type());
    }

    default public Entity<T> playBackToEvent(String eventId) {
        return this.playBackToCondition(aggregate -> Objects.equals(eventId, aggregate.lastEventId())).orElseThrow(() -> new IllegalStateException(String.format("Could not load aggregate %s of type %s for event %s. Aggregate (%s) started at event %s", this.id(), this.type().getSimpleName(), eventId, this, this.lastEventId())));
    }

    default public Optional<Entity<T>> playBackToCondition(Predicate<Entity<T>> condition) {
        Entity<T> result;
        for (result = this; result != null && !condition.test(result); result = result.previous()) {
        }
        return Optional.ofNullable(result);
    }

    public Collection<? extends Entity<?>> entities();

    default public Stream<Entity<?>> allEntities() {
        return Stream.concat(Stream.of(this), this.entities().stream().flatMap(Entity::allEntities));
    }

    default public Optional<Entity<?>> getEntity(Object entityId) {
        return entityId == null ? Optional.empty() : this.allEntities().filter(e -> entityId.equals(e.id()) || e.aliases().contains(entityId)).findFirst();
    }

    default public Set<Relationship> relationships() {
        if (this.get() == null) {
            return Collections.emptySet();
        }
        String id = this.id().toString();
        String type = this.type().getName();
        return this.allEntities().filter(e -> e.id() != null).flatMap(e -> Stream.concat(Stream.of(e.id()), e.aliases().stream())).map(entityId -> Relationship.builder().entityId(entityId.toString()).aggregateType(type).aggregateId(id).build()).collect(Collectors.toSet());
    }

    default public Set<Relationship> associations(Entity<?> previous) {
        HashSet<Relationship> result = new HashSet<Relationship>(this.relationships());
        result.removeAll(previous.relationships());
        return result;
    }

    default public Set<Relationship> dissociations(Entity<?> previous) {
        HashSet<Relationship> result = new HashSet<Relationship>(previous.relationships());
        result.removeAll(this.relationships());
        return result;
    }

    public Entity<T> update(UnaryOperator<T> var1);

    default public Entity<T> apply(Object ... events) {
        return this.apply(List.of(events));
    }

    default public Entity<T> apply(Collection<?> events) {
        Entity<T> result = this;
        for (Object event : events) {
            result = result.apply(event);
        }
        return result;
    }

    default public Entity<T> apply(Object event) {
        Entity<T> entity;
        if (event instanceof DeserializingMessage) {
            DeserializingMessage d = (DeserializingMessage)event;
            entity = this.apply(d);
        } else {
            entity = this.apply(Message.asMessage(event));
        }
        return entity;
    }

    default public Entity<T> apply(Object event, Metadata metadata) {
        return this.apply(new Message(event, metadata));
    }

    default public Entity<T> apply(DeserializingMessage eventMessage) {
        return this.apply(eventMessage.toMessage());
    }

    public Entity<T> apply(Message var1);

    public <E extends Exception> Entity<T> assertLegal(Object var1) throws E;

    default public Entity<T> assertAndApply(Object payloadOrMessage) {
        return this.assertLegal(payloadOrMessage).apply(payloadOrMessage);
    }

    default public Entity<T> assertAndApply(Object payload, Metadata metadata) {
        return this.assertAndApply((Object)new Message(payload, metadata));
    }

    default public Entity<T> assertAndApply(Object ... events) {
        return this.assertAndApply(List.of(events));
    }

    default public Entity<T> assertAndApply(Collection<?> events) {
        Entity<T> result = this;
        for (Object event : events) {
            result = result.assertAndApply(event);
        }
        return result;
    }

    default public <E extends Exception> Entity<T> assertThat(Validator<T, E> validator) throws E {
        validator.validate(this.get());
        return this;
    }

    default public <E extends Exception> Entity<T> ensure(Predicate<T> check, Function<T, E> errorProvider) throws E {
        if (!check.test(this.get())) {
            throw (Exception)errorProvider.apply(this.get());
        }
        return this;
    }

    default public Iterable<Entity<?>> possibleTargets(Object payload) {
        if (payload != null) {
            for (Entity<?> e : this.entities()) {
                if (!e.isPossibleTarget(payload)) continue;
                return List.of(e);
            }
        }
        return Collections.emptyList();
    }

    private boolean isPossibleTarget(Object message) {
        Object payload;
        if (message == null) {
            return false;
        }
        String idProperty = this.idProperty();
        Object id = this.id();
        if (idProperty == null) {
            return true;
        }
        if (id == null && this.get() != null) {
            return false;
        }
        Object object = payload = message instanceof Message ? ((Message)message).getPayload() : message;
        if (id == null) {
            return ReflectionUtils.hasProperty((String)idProperty, (Object)payload);
        }
        if (ReflectionUtils.readProperty((String)idProperty, (Object)payload).or(() -> ReflectionUtils.getAnnotatedPropertyValue((Object)payload, RoutingKey.class)).map(id::equals).orElse(false).booleanValue()) {
            return true;
        }
        if (!ReflectionUtils.hasProperty((String)idProperty, (Object)payload)) {
            for (Entity<?> e : this.entities()) {
                if (!e.isPossibleTarget(message)) continue;
                return true;
            }
        }
        return false;
    }

    private <U> Entity<U> findEntity(Object id, Class<U> type) {
        return this.allEntities().filter(e -> Objects.equals(e.id(), id) && e.type().isAssignableFrom(type)).findFirst().orElse(null);
    }

    @FunctionalInterface
    public static interface Validator<T, E extends Exception> {
        public void validate(T var1) throws E;
    }
}

