/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.modeling;

import io.fluxcapacitor.common.handling.ParameterResolver;
import io.fluxcapacitor.common.reflection.ReflectionUtils;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.common.HasMessage;
import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.HasEntity;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class EntityParameterResolver
implements ParameterResolver<Object> {
    public Function<Object, Object> resolve(Parameter parameter, Annotation methodAnnotation) {
        return m -> this.resolve(parameter, this.getMatchingEntity(m, parameter)).get();
    }

    public boolean matches(Parameter parameter, Annotation methodAnnotation, Object input) {
        return this.matches(parameter, this.getMatchingEntity(input, parameter));
    }

    protected Entity<?> getMatchingEntity(Object input, Parameter parameter) {
        if (input instanceof HasEntity) {
            return ((HasEntity)input).getEntity();
        }
        if (input instanceof HasMessage && (Entity.class.isAssignableFrom(parameter.getType()) || Optional.ofNullable(Entity.getAggregateType((HasMessage)input)).map(t -> parameter.getType().isAssignableFrom((Class<?>)t)).orElse(false).booleanValue())) {
            return Optional.ofNullable(Entity.getAggregateId((HasMessage)input)).or(() -> ((HasMessage)input).computeRoutingKey()).flatMap(entityId -> FluxCapacitor.getOptionally().map(fc -> FluxCapacitor.loadEntity(entityId))).orElse(null);
        }
        return null;
    }

    protected boolean matches(Parameter parameter, Entity<?> entity) {
        if (entity == null) {
            return false;
        }
        if (this.isAssignable(parameter, entity)) {
            return true;
        }
        return this.matches(parameter, entity.parent());
    }

    protected Supplier<?> resolve(Parameter parameter, Entity<?> entity) {
        if (entity == null) {
            return () -> null;
        }
        if (this.isAssignable(parameter, entity)) {
            return Entity.class.isAssignableFrom(parameter.getType()) ? () -> entity : entity::get;
        }
        return this.resolve(parameter, entity.parent());
    }

    protected boolean isAssignable(Parameter parameter, Entity<?> entity) {
        Class<?> eType = entity.type();
        Class<?> pType = this.getEntityParameterType(parameter);
        return entity.get() == null ? (ReflectionUtils.isNullable((Parameter)parameter) || Entity.class.isAssignableFrom(parameter.getType())) && (pType.isAssignableFrom(eType) || eType.isAssignableFrom(pType)) : pType.isAssignableFrom(eType);
    }

    private Class<?> getEntityParameterType(Parameter parameter) {
        if (Entity.class.equals(parameter.getType())) {
            Type[] actualTypeArguments;
            Type parameterizedType = parameter.getParameterizedType();
            if (parameterizedType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)parameterizedType).getActualTypeArguments()).length == 1) {
                Type actualType = actualTypeArguments[0];
                if (actualType instanceof Class) {
                    return (Class)actualType;
                }
                if (actualType instanceof WildcardType) {
                    Type[] lowerBounds = ((WildcardType)actualType).getLowerBounds();
                    if (lowerBounds.length == 0) {
                        return Object.class;
                    }
                    Type lowerBound = lowerBounds[0];
                    if (lowerBound instanceof Class) {
                        return (Class)lowerBound;
                    }
                    if (lowerBound instanceof ParameterizedType && (lowerBound = ((ParameterizedType)lowerBound).getRawType()) instanceof Class) {
                        return (Class)lowerBound;
                    }
                }
            }
            return Object.class;
        }
        return parameter.getType();
    }

    public boolean determinesSpecificity() {
        return true;
    }
}

