/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetRelationships;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.api.modeling.RepairRelationships;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.InMemoryEventStore;
import io.fluxcapacitor.javaclient.tracking.client.LocalTrackingClient;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class LocalEventStoreClient
extends LocalTrackingClient
implements EventStoreClient {
    public LocalEventStoreClient(Duration messageExpiration) {
        super(new InMemoryEventStore(messageExpiration), MessageType.EVENT);
    }

    @Override
    public InMemoryEventStore getMessageStore() {
        return (InMemoryEventStore)super.getMessageStore();
    }

    @Override
    public CompletableFuture<Void> storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly, Guarantee guarantee) {
        return this.getMessageStore().storeEvents(aggregateId, events, storeOnly, guarantee);
    }

    @Override
    public CompletableFuture<Void> updateRelationships(UpdateRelationships request) {
        return this.getMessageStore().updateRelationships(request);
    }

    @Override
    public CompletableFuture<Void> repairRelationships(RepairRelationships request) {
        return this.getMessageStore().repairRelationships(request);
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber, int maxSize) {
        return this.getMessageStore().getEvents(aggregateId, lastSequenceNumber, maxSize);
    }

    @Override
    public CompletableFuture<Void> deleteEvents(String aggregateId, Guarantee guarantee) {
        return this.getMessageStore().deleteEvents(aggregateId, guarantee);
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return this.getMessageStore().getAggregateIds(request);
    }

    @Override
    public List<Relationship> getRelationships(GetRelationships request) {
        return this.getMessageStore().getRelationships(request);
    }

    public CompletableFuture<Void> append(List<SerializedMessage> messages) {
        return this.getMessageStore().append(messages);
    }

    public List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        return this.getMessageStore().getBatch(minIndex, maxSize, inclusive);
    }

    public void notifyMonitors() {
        this.getMessageStore().notifyMonitors();
    }

    public void notifyMonitors(List<SerializedMessage> messages) {
        this.getMessageStore().notifyMonitors(messages);
    }

    @Override
    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.getMessageStore().registerMonitor(monitor);
    }

    @Override
    public void close() {
        this.getMessageStore().close();
    }

    @Override
    public MessageType getMessageType() {
        return this.getMessageStore().getMessageType();
    }

    public Duration getMessageExpiration() {
        return this.getMessageStore().getMessageExpiration();
    }

    public CompletableFuture<Void> append(SerializedMessage ... messages) {
        return this.getMessageStore().append(messages);
    }

    public List<SerializedMessage> getBatch(Long minIndex, int maxSize) {
        return this.getMessageStore().getBatch(minIndex, maxSize);
    }

    public <T extends MessageStore> T unwrap(Class<T> type) {
        return (T)this.getMessageStore().unwrap(type);
    }

    @Override
    public CompletableFuture<Void> storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly) {
        return this.getMessageStore().storeEvents(aggregateId, events, storeOnly);
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId) {
        return this.getMessageStore().getEvents(aggregateId);
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber) {
        return this.getMessageStore().getEvents(aggregateId, lastSequenceNumber);
    }

    @Override
    public CompletableFuture<Void> deleteEvents(String aggregateId) {
        return this.getMessageStore().deleteEvents(aggregateId);
    }

    @Override
    public Map<String, String> getAggregatesFor(String entityId) {
        return this.getMessageStore().getAggregatesFor(entityId);
    }

    @Override
    public List<Relationship> getRelationships(String entityId) {
        return this.getMessageStore().getRelationships(entityId);
    }
}

