/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.eventsourcing.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.api.Command;
import io.fluxcapacitor.common.api.Request;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.eventsourcing.AppendEvents;
import io.fluxcapacitor.common.api.eventsourcing.DeleteEvents;
import io.fluxcapacitor.common.api.eventsourcing.EventBatch;
import io.fluxcapacitor.common.api.eventsourcing.GetEvents;
import io.fluxcapacitor.common.api.eventsourcing.GetEventsResult;
import io.fluxcapacitor.common.api.modeling.GetAggregateIds;
import io.fluxcapacitor.common.api.modeling.GetAggregateIdsResult;
import io.fluxcapacitor.common.api.modeling.GetRelationships;
import io.fluxcapacitor.common.api.modeling.GetRelationshipsResult;
import io.fluxcapacitor.common.api.modeling.Relationship;
import io.fluxcapacitor.common.api.modeling.RepairRelationships;
import io.fluxcapacitor.common.api.modeling.UpdateRelationships;
import io.fluxcapacitor.javaclient.common.websocket.AbstractWebsocketClient;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.AggregateEventStream;
import io.fluxcapacitor.javaclient.persisting.eventsourcing.client.EventStoreClient;
import jakarta.websocket.ClientEndpoint;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

@ClientEndpoint
public class WebSocketEventStoreClient
extends AbstractWebsocketClient
implements EventStoreClient {
    private final int fetchBatchSize;

    public WebSocketEventStoreClient(String endPointUrl, WebSocketClient client) {
        this(URI.create(endPointUrl), 8192, client);
    }

    public WebSocketEventStoreClient(URI endPointUri, int fetchBatchSize, WebSocketClient client) {
        this(endPointUri, fetchBatchSize, client, true);
    }

    public WebSocketEventStoreClient(URI endPointUri, int fetchBatchSize, WebSocketClient client, boolean sendMetrics) {
        super(endPointUri, client, sendMetrics, client.getClientConfig().getEventSourcingSessions());
        this.fetchBatchSize = fetchBatchSize;
    }

    @Override
    public CompletableFuture<Void> storeEvents(String aggregateId, List<SerializedMessage> events, boolean storeOnly, Guarantee guarantee) {
        return this.sendCommand((Command)new AppendEvents(List.of(new EventBatch(aggregateId, events, storeOnly)), guarantee));
    }

    @Override
    public AggregateEventStream<SerializedMessage> getEvents(String aggregateId, long lastSequenceNumber, int maxSize) {
        AtomicReference highestSequenceNumber = new AtomicReference();
        AtomicInteger fetchedSize = new AtomicInteger();
        GetEventsResult firstBatch = (GetEventsResult)this.sendAndWait((Request)new GetEvents(aggregateId, Long.valueOf(lastSequenceNumber), maxSize <= 0 ? this.fetchBatchSize : maxSize));
        Stream eventStream = ObjectUtils.iterate((Object)firstBatch, r -> (GetEventsResult)this.sendAndWait((Request)new GetEvents(aggregateId, Long.valueOf(r.getLastSequenceNumber()), maxSize <= 0 ? this.fetchBatchSize : maxSize - fetchedSize.get())), r -> r.getEventBatch().getEvents().size() < this.fetchBatchSize).flatMap(r -> {
            if (!r.getEventBatch().isEmpty()) {
                fetchedSize.addAndGet(r.getEventBatch().getSize());
                highestSequenceNumber.set(r.getLastSequenceNumber());
            }
            return r.getEventBatch().getEvents().stream();
        });
        return new AggregateEventStream<SerializedMessage>(eventStream, aggregateId, highestSequenceNumber::get);
    }

    @Override
    public CompletableFuture<Void> updateRelationships(UpdateRelationships request) {
        return this.sendCommand((Command)request);
    }

    @Override
    public CompletableFuture<Void> repairRelationships(RepairRelationships request) {
        return this.sendCommand((Command)request);
    }

    @Override
    public Map<String, String> getAggregateIds(GetAggregateIds request) {
        return ((GetAggregateIdsResult)this.sendAndWait((Request)request)).getAggregateIds();
    }

    @Override
    public List<Relationship> getRelationships(GetRelationships request) {
        return ((GetRelationshipsResult)this.sendAndWait((Request)request)).getRelationships();
    }

    @Override
    public CompletableFuture<Void> deleteEvents(String aggregateId, Guarantee guarantee) {
        return this.sendCommand((Command)new DeleteEvents(aggregateId, guarantee));
    }
}

