/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.persisting.repository;

import io.fluxcapacitor.javaclient.modeling.Entity;
import io.fluxcapacitor.javaclient.modeling.Id;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public interface AggregateRepository {
    default public <T> Entity<T> load(Id<T> aggregateId) {
        return this.load(aggregateId.toString(), aggregateId.getType());
    }

    public <T> Entity<T> load(@NonNull Object var1, Class<T> var2);

    public <T> Entity<T> loadFor(@NonNull Object var1, Class<?> var2);

    default public CompletableFuture<Void> repairRelationships(Id<?> aggregateId) {
        return this.repairRelationships(this.load(aggregateId));
    }

    default public CompletableFuture<Void> repairRelationships(Object aggregateId) {
        return this.repairRelationships(this.load(aggregateId, Object.class));
    }

    public CompletableFuture<Void> repairRelationships(Entity<?> var1);

    public Map<String, Class<?>> getAggregatesFor(Object var1);

    default public Optional<String> getLatestAggregateId(Object entityId) {
        return this.getAggregatesFor(entityId).keySet().stream().reduce((a, b) -> b);
    }
}

