/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking;

import io.fluxcapacitor.javaclient.FluxCapacitor;
import java.time.Instant;

public class IndexUtils {
    public static long millisFromIndex(long index) {
        return index >> 16;
    }

    public static Instant timestampFromIndex(long index) {
        return Instant.ofEpochMilli(IndexUtils.millisFromIndex(index));
    }

    public static long indexFromTimestamp(Instant timestamp) {
        return IndexUtils.indexFromMillis(timestamp.toEpochMilli());
    }

    public static long indexFromMillis(long millisSinceEpoch) {
        return millisSinceEpoch << 16;
    }

    public static long maxIndexFromMillis(long millisSinceEpoch) {
        return IndexUtils.indexFromMillis(millisSinceEpoch) + 65536L - 1L;
    }

    public static int offsetFromIndex(long index) {
        return (int)(index % 65536L);
    }

    public static long indexForCurrentTime() {
        return FluxCapacitor.currentClock().millis() << 16;
    }

    public static long nextIndex(Long lastIndex) {
        return lastIndex == null ? IndexUtils.indexForCurrentTime() : Math.max(IndexUtils.indexForCurrentTime(), lastIndex + 1L);
    }
}

