/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.ObjectUtils;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.javaclient.FluxCapacitor;
import io.fluxcapacitor.javaclient.tracking.IndexUtils;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMessageStore
implements MessageStore {
    private static final Logger log = LoggerFactory.getLogger(InMemoryMessageStore.class);
    private final Set<Consumer<List<SerializedMessage>>> monitors = new CopyOnWriteArraySet<Consumer<List<SerializedMessage>>>();
    private final ExecutorService executor = Executors.newCachedThreadPool(ObjectUtils.newThreadFactory((String)"InMemoryMessageStore"));
    private final AtomicLong nextIndex = new AtomicLong();
    private final ConcurrentSkipListMap<Long, SerializedMessage> messageLog = new ConcurrentSkipListMap();
    private final MessageType messageType;
    private final Duration messageExpiration;

    public InMemoryMessageStore(MessageType messageType) {
        this(messageType, Duration.ofMinutes(2L));
    }

    public synchronized CompletableFuture<Void> append(List<SerializedMessage> messages) {
        try {
            messages.forEach(m -> {
                if (m.getIndex() == null) {
                    m.setIndex(Long.valueOf(this.nextIndex.updateAndGet(IndexUtils::nextIndex)));
                }
                this.messageLog.put(m.getIndex(), (SerializedMessage)m);
            });
            if (this.messageExpiration != null) {
                this.purgeExpiredMessages(this.messageExpiration);
            }
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            return completableFuture;
        }
        finally {
            this.notifyMonitors(messages);
        }
    }

    public List<SerializedMessage> getBatch(Long minIndex, int maxSize, boolean inclusive) {
        ArrayList<SerializedMessage> list = new ArrayList<SerializedMessage>(this.filterMessages(this.messageLog.tailMap((Object)Optional.ofNullable(minIndex).map(i -> inclusive ? i : i + 1L).orElse(-1L)).values()));
        return list.subList(0, Math.min(maxSize, list.size()));
    }

    public void notifyMonitors() {
        this.notifyMonitors(Collections.emptyList());
    }

    public synchronized void notifyMonitors(List<SerializedMessage> messages) {
        this.notifyAll();
        if (!this.monitors.isEmpty()) {
            this.monitors.forEach(m -> m.accept(messages));
        }
    }

    protected void purgeExpiredMessages(Duration messageExpiration) {
        long threshold = FluxCapacitor.currentTime().minus(messageExpiration).toEpochMilli();
        this.messageLog.headMap((Object)IndexUtils.maxIndexFromMillis(threshold), true).clear();
    }

    protected Collection<SerializedMessage> filterMessages(Collection<SerializedMessage> messages) {
        return messages;
    }

    protected SerializedMessage getMessage(long index) {
        return this.messageLog.get(index);
    }

    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        this.monitors.add(monitor);
        return () -> this.monitors.remove(monitor);
    }

    public void close() {
        this.executor.shutdownNow();
    }

    @ConstructorProperties(value={"messageType", "messageExpiration"})
    public InMemoryMessageStore(MessageType messageType, Duration messageExpiration) {
        this.messageType = messageType;
        this.messageExpiration = messageExpiration;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Duration getMessageExpiration() {
        return this.messageExpiration;
    }
}

