/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.tracking.client;

import io.fluxcapacitor.common.Guarantee;
import io.fluxcapacitor.common.MessageType;
import io.fluxcapacitor.common.Registration;
import io.fluxcapacitor.common.api.SerializedMessage;
import io.fluxcapacitor.common.api.tracking.MessageBatch;
import io.fluxcapacitor.common.api.tracking.Position;
import io.fluxcapacitor.common.api.tracking.Read;
import io.fluxcapacitor.common.tracking.DefaultTrackingStrategy;
import io.fluxcapacitor.common.tracking.HasMessageStore;
import io.fluxcapacitor.common.tracking.InMemoryPositionStore;
import io.fluxcapacitor.common.tracking.MessageStore;
import io.fluxcapacitor.common.tracking.PositionStore;
import io.fluxcapacitor.common.tracking.Tracker;
import io.fluxcapacitor.common.tracking.TrackingStrategy;
import io.fluxcapacitor.common.tracking.WebSocketTracker;
import io.fluxcapacitor.javaclient.publishing.client.GatewayClient;
import io.fluxcapacitor.javaclient.tracking.ConsumerConfiguration;
import io.fluxcapacitor.javaclient.tracking.client.InMemoryMessageStore;
import io.fluxcapacitor.javaclient.tracking.client.TrackingClient;
import java.beans.ConstructorProperties;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class LocalTrackingClient
implements TrackingClient,
GatewayClient,
HasMessageStore {
    private final TrackingStrategy trackingStrategy;
    private final MessageStore messageStore;
    private final PositionStore positionStore;
    private final MessageType messageType;

    public LocalTrackingClient(MessageType messageType, Duration messageExpiration) {
        this.messageStore = new InMemoryMessageStore(messageType, messageExpiration);
        this.trackingStrategy = new DefaultTrackingStrategy(this.messageStore);
        this.positionStore = new InMemoryPositionStore();
        this.messageType = messageType;
    }

    public LocalTrackingClient(MessageStore messageStore, MessageType messageType) {
        this.messageStore = messageStore;
        this.messageType = messageType;
        this.trackingStrategy = new DefaultTrackingStrategy(messageStore);
        this.positionStore = new InMemoryPositionStore();
    }

    public Registration registerMonitor(Consumer<List<SerializedMessage>> monitor) {
        return this.messageStore.registerMonitor(monitor);
    }

    @Override
    public CompletableFuture<Void> append(Guarantee guarantee, SerializedMessage ... messages) {
        return this.messageStore.append(messages);
    }

    @Override
    public CompletableFuture<MessageBatch> read(String consumer, String trackerId, Long lastIndex, ConsumerConfiguration config) {
        CompletableFuture<MessageBatch> result = new CompletableFuture<MessageBatch>();
        this.trackingStrategy.getBatch((Tracker)new WebSocketTracker(new Read(this.messageType, consumer, trackerId, config.getMaxFetchSize(), config.getMaxWaitDuration().toMillis(), config.getTypeFilter(), config.filterMessageTarget(), config.ignoreSegment(), config.singleTracker(), config.clientControlledIndex(), Long.valueOf(lastIndex == null ? -1L : lastIndex), (Long)Optional.ofNullable(config.getPurgeDelay()).map(Duration::toMillis).orElse(null)), this.messageType, ManagementFactory.getRuntimeMXBean().getName(), null, result::complete), this.positionStore);
        return result;
    }

    @Override
    public List<SerializedMessage> readFromIndex(long minIndex, int maxSize) {
        return this.messageStore.getBatch(Long.valueOf(minIndex), maxSize, true);
    }

    @Override
    public CompletableFuture<Void> storePosition(String consumer, int[] segment, long lastIndex, Guarantee guarantee) {
        return this.positionStore.storePosition(consumer, segment, lastIndex);
    }

    @Override
    public CompletableFuture<Void> resetPosition(String consumer, long lastIndex, Guarantee guarantee) {
        return this.positionStore.resetPosition(consumer, lastIndex);
    }

    @Override
    public Position getPosition(String consumer) {
        return this.positionStore.position(consumer);
    }

    @Override
    public CompletableFuture<Void> disconnectTracker(String consumer, String trackerId, boolean sendFinalEmptyBatch, Guarantee guarantee) {
        this.trackingStrategy.disconnectTrackers(t -> t.getTrackerId().equalsIgnoreCase(trackerId), sendFinalEmptyBatch);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void close() {
        this.messageStore.close();
        this.trackingStrategy.close();
    }

    @ConstructorProperties(value={"trackingStrategy", "messageStore", "positionStore", "messageType"})
    public LocalTrackingClient(TrackingStrategy trackingStrategy, MessageStore messageStore, PositionStore positionStore, MessageType messageType) {
        this.trackingStrategy = trackingStrategy;
        this.messageStore = messageStore;
        this.positionStore = positionStore;
        this.messageType = messageType;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }
}

