/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.web;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;

public enum HttpRequestMethod {
    GET,
    POST,
    PUT,
    PATCH,
    DELETE,
    HEAD,
    OPTIONS,
    TRACE,
    WS_HANDSHAKE(true),
    WS_OPEN(true),
    WS_MESSAGE(true),
    WS_CLOSE(true),
    WS_PONG(true);

    private final boolean websocket;
    private static final Collection<HttpRequestMethod> standardMethods;

    private HttpRequestMethod() {
        this(false);
    }

    public boolean isWebsocket() {
        return this.websocket;
    }

    @ConstructorProperties(value={"websocket"})
    private HttpRequestMethod(boolean websocket) {
        this.websocket = websocket;
    }

    public static Collection<HttpRequestMethod> getStandardMethods() {
        return standardMethods;
    }

    static {
        standardMethods = Arrays.stream(HttpRequestMethod.values()).filter(m -> !m.isWebsocket()).toList();
    }
}

