/*
 * Decompiled with CFR 0.152.
 */
package io.fluxcapacitor.javaclient.benchmark;

import io.fluxcapacitor.common.TimingUtils;
import io.fluxcapacitor.javaclient.configuration.client.WebSocketClient;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientBenchmark {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractClientBenchmark.class);
    private final CountDownLatch commandCountDownLatch;
    private final WebSocketClient.ClientConfig clientConfig;
    private final int commandCount;

    public AbstractClientBenchmark(int commandCount, WebSocketClient.ClientConfig clientConfig) {
        this.commandCount = commandCount;
        this.commandCountDownLatch = new CountDownLatch(commandCount);
        this.clientConfig = clientConfig;
    }

    public AbstractClientBenchmark(int commandCount) {
        this(commandCount, WebSocketClient.ClientConfig.builder().name("benchmark-" + String.valueOf(UUID.randomUUID())).serviceBaseUrl("ws://localhost:8081").build());
    }

    protected void testCommands() {
        int count = (int)this.commandCountDownLatch.getCount();
        log.info("Start sending {} commands", (Object)count);
        TimingUtils.time(() -> {
            IntStream.range(0, count).forEach(i -> this.doSendCommand("payload" + i));
            try {
                this.commandCountDownLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }, duration -> log.info("Finished sending and handling {} commands in {}ms", (Object)count, duration));
    }

    protected int getCommandCount() {
        return this.commandCount;
    }

    protected abstract void doSendCommand(String var1);

    @Generated
    public CountDownLatch getCommandCountDownLatch() {
        return this.commandCountDownLatch;
    }

    @Generated
    public WebSocketClient.ClientConfig getClientConfig() {
        return this.clientConfig;
    }
}

