package ru.foodtechlab.lib.auth.integration.inner.authSessions.mapper;

import com.rcore.commons.mapper.DataMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.integration.inner.credential.mapper.CredentialResponseMapper;
import ru.foodtechlab.lib.auth.integration.inner.role.mapper.RoleResponseMapper;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.AuthSessionEntity;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.ClientInfo;
import ru.foodtechlab.lib.auth.service.domain.auth.entity.LoginDetails;
import ru.foodtechlab.lib.auth.service.domain.credential.entity.PhoneNumber;
import ru.foodtechlab.lib.auth.service.facade.authorizationSession.dto.responses.AuthorizationSessionResponse;
import ru.foodtechlab.lib.auth.service.facade.confirmationCode.dto.responses.ConfirmationCodeResponse;

import java.util.Optional;

@RequiredArgsConstructor
@Component
public class AuthorizationSessionResponseMapper implements DataMapper<AuthSessionEntity, AuthorizationSessionResponse> {

    private final CredentialResponseMapper credentialResponseMapper;
    private final RoleResponseMapper roleResponseMapper;

    @Override
    public AuthorizationSessionResponse map(AuthSessionEntity entity) {
        return AuthorizationSessionResponse.builder()
                .id(entity.getId())
                .createdAt(entity.getCreatedAt())
                .updatedAt(entity.getUpdatedAt())
                .isRegistrationAllowed(entity.isRegistrationAllowed())
                .confirmationCodeType(Optional.ofNullable(entity.getConfirmationCodeType())
                        .map(t -> ConfirmationCodeResponse.Type.valueOf(t.toString()))
                        .orElse(null))
                .ttl(entity.getTtl())
                .expireAt(entity.getExpiredAt())
                .credential(Optional.ofNullable(entity.getCredential())
                        .map(credentialResponseMapper::map)
                        .orElse(null))
                .role(Optional.ofNullable(entity.getTargetRole()).map(roleResponseMapper::map).orElse(null))
                .status(AuthorizationSessionResponse.Status.valueOf(entity.getStatus().name()))
                .type(AuthorizationSessionResponse.Type.valueOf(entity.getType().name()))
                .loginType(AuthorizationSessionResponse.LoginType.valueOf(entity.getLoginType().name()))
                .errors(entity.getErrors())
                .authSessionLoginConfirmAttemptsLimit(entity.getAuthSessionLoginConfirmAttemptsLimit())
                .authSessionLoginConfirmAttempts(entity.getAuthSessionLoginConfirmAttempts())
                .authSessionLoginInitAttempts(entity.getAuthSessionLoginInitAttempts())
                .phoneNumber(Optional.ofNullable(entity.getLoginDetails())
                        .filter(l -> l.getPhoneNumber()!=null)
                        .map(l -> l.getPhoneNumber().toString())
                        .orElse(null))
                .isoTwoLetterCountryCode(Optional.ofNullable(entity.getLoginDetails().getPhoneNumber())
                        .map(PhoneNumber::getIsoTwoLetterCountryCode)
                        .orElse(null))
                .email(Optional.ofNullable(entity.getLoginDetails())
                        .map(LoginDetails::getEmail)
                        .orElse(null))
                .username(Optional.ofNullable(entity.getLoginDetails())
                        .map(LoginDetails::getUsername)
                        .orElse(null))
                .applicationDetails(Optional.ofNullable(entity.getClientInfo())
                        .map(c -> new AuthorizationSessionResponse.ApplicationDetails(c.getApplication(), c.getPlatform(),c.getVersionName()))
                        .orElse(null))
                .deviceId(Optional.ofNullable(entity.getClientInfo()).map(ClientInfo::getDeviceId).orElse(null))
                .ipV4(Optional.ofNullable(entity.getClientInfo()).map(ClientInfo::getIp).orElse(null))
                .isDeleted(entity.isDeleted())
                .build();
    }
}
