package ru.foodtechlab.lib.auth.integration.inner.authorization.mapper;

import com.rcore.commons.mapper.DataMapper;
import org.springframework.stereotype.Component;
import ru.foodtechlab.lib.auth.service.domain.auth.usecases.PasswordAuthUseCase;
import ru.foodtechlab.lib.auth.service.facade.authorization.dto.responses.BasicAuthorizationResponse;

@Component
public class BasicAuthorizationResponseMapper implements DataMapper<PasswordAuthUseCase.OutputValues, BasicAuthorizationResponse> {

    @Override
    public BasicAuthorizationResponse map(PasswordAuthUseCase.OutputValues outputValues) {
        return BasicAuthorizationResponse.builder()
                .accessToken(outputValues.getTokenPair().getAccessToken())
                .refreshToken(outputValues.getTokenPair().getRefreshToken())
                .credentialId(outputValues.getCredential().getId())
                .build();
    }
}
